/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.xml.sax.SAXException;

public class XMIReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_FILES = "files";
    @ConfigurationParameter(name="files", mandatory=true, description="The XMI files to be loaded")
    private List<File> files;
    private Iterator<File> filesIter;
    private int completed;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.filesIter = this.files.iterator();
        this.completed = 0;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.completed, this.files.size(), "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.filesIter.hasNext();
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        FileInputStream inputStream = new FileInputStream(this.filesIter.next());
        try {
            XmiCasDeserializer.deserialize((InputStream)new BufferedInputStream(inputStream), (CAS)jCas.getCas());
        }
        catch (SAXException e) {
            throw new CollectionException((Throwable)e);
        }
        inputStream.close();
        ++this.completed;
    }
}

