/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.nlp.tokenizer;

import java.util.HashMap;
import org.apache.ctakes.core.nlp.tokenizer.ContractionResult;
import org.apache.ctakes.core.nlp.tokenizer.HyphenatedPTB;
import org.apache.ctakes.core.nlp.tokenizer.TokenizerHelper;

public class ContractionsPTB {
    static String[] MultiTokenWords = new String[]{"cannot", "gonna", "gotta", "lemme", "wanna", "whaddya", "whatcha"};
    static int[] MultiTokenWordLenToken1 = new int[]{3, 3, 3, 3, 3, 3, 3};
    static int[] MultiTokenWordLenToken2 = new int[]{3, 2, 2, 2, 2, 2, 1};
    static int[] MultiTokenWordLenToken3 = new int[]{0, 0, 0, 0, 0, 2, 3};
    static HashMap<String, Integer> MultiTokenWordsLookup = new HashMap();
    static String[] possibleContractionEndings;
    static String lettersAfterApostropheForMiddleOfContraction;
    static String[] contractionsStartingWithApostrophe;
    private static String[] fullWordsNotToBreakAtApostrophe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_getLengthIfNextApostIsMiddleOfContraction() {
        String before = "";
        String rest = "It's a deal";
        String text = before + rest;
        int position = before.length();
        int nextNonCharDigitApostrophe = text.indexOf(39, position);
        int expectedLenWordToken = 2;
        int expectedLenContractionToken = 2;
        ContractionResult cr = ContractionsPTB.getLengthIfNextApostIsMiddleOfContraction(position, nextNonCharDigitApostrophe, text);
        System.out.println("INFO: for text = " + text + ", result = " + cr.getWordTokenLen() + " " + cr.getContractionTokenLen());
        assert (cr.getWordTokenLen() == expectedLenWordToken);
        assert (cr.getContractionTokenLen() == expectedLenContractionToken);
        before = "He ";
        rest = "can't do that";
        text = before + rest;
        position = before.length();
        nextNonCharDigitApostrophe = text.indexOf(39, position);
        expectedLenWordToken = 2;
        expectedLenContractionToken = 3;
        cr = ContractionsPTB.getLengthIfNextApostIsMiddleOfContraction(position, nextNonCharDigitApostrophe, text);
        System.out.println("INFO: for text = " + text + ", result = " + cr.getWordTokenLen() + " " + cr.getContractionTokenLen());
        assert (cr.getWordTokenLen() == expectedLenWordToken);
        assert (cr.getContractionTokenLen() == expectedLenContractionToken);
        before = "He ";
        rest = "should've done that";
        text = before + rest;
        position = before.length();
        nextNonCharDigitApostrophe = text.indexOf(39, position);
        expectedLenWordToken = 6;
        expectedLenContractionToken = 3;
        cr = ContractionsPTB.getLengthIfNextApostIsMiddleOfContraction(position, nextNonCharDigitApostrophe, text);
        System.out.println("INFO: for text = " + text + ", result = " + cr.getWordTokenLen() + " " + cr.getContractionTokenLen());
        assert (cr.getWordTokenLen() == expectedLenWordToken);
        assert (cr.getContractionTokenLen() == expectedLenContractionToken);
        before = "they have ";
        rest = "more'n they can use";
        text = before + rest;
        position = before.length();
        nextNonCharDigitApostrophe = text.indexOf(39, position);
        expectedLenWordToken = 4;
        expectedLenContractionToken = 2;
        cr = ContractionsPTB.getLengthIfNextApostIsMiddleOfContraction(position, nextNonCharDigitApostrophe, text);
        System.out.println("INFO: for text = " + text + ", result = " + cr.getWordTokenLen() + " " + cr.getContractionTokenLen());
        assert (cr.getWordTokenLen() == expectedLenWordToken);
        assert (cr.getContractionTokenLen() == expectedLenContractionToken);
        before = "";
        rest = "he'll see you now";
        text = before + rest;
        position = before.length();
        nextNonCharDigitApostrophe = text.indexOf(39, position);
        expectedLenWordToken = 2;
        expectedLenContractionToken = 3;
        cr = ContractionsPTB.getLengthIfNextApostIsMiddleOfContraction(position, nextNonCharDigitApostrophe, text);
        System.out.println("INFO: for text = " + text + ", result = " + cr.getWordTokenLen() + " " + cr.getContractionTokenLen());
        assert (cr.getWordTokenLen() == expectedLenWordToken);
        assert (cr.getContractionTokenLen() == expectedLenContractionToken);
        System.out.println("TEST THAT ASSERT IS ENABLED:");
        boolean assertionErrorCaught = false;
        try {
            assert (false);
        }
        catch (AssertionError e) {
            assertionErrorCaught = true;
        }
        finally {
            if (assertionErrorCaught) {
                System.out.println("As expected, assertionErrorCaught = " + assertionErrorCaught);
            } else {
                System.out.println("ERROR: Unexpected: assertionErrorCaught = " + assertionErrorCaught);
            }
        }
    }

    public static ContractionResult getLengthIfNextApostIsMiddleOfContraction(int position, int nextNonLetterDigit, String lowerCasedText) {
        if (position < 0) {
            return null;
        }
        if (lowerCasedText.length() < position + 3) {
            return null;
        }
        int apostrophePosition = lowerCasedText.indexOf(39, position);
        if (nextNonLetterDigit != apostrophePosition) {
            return null;
        }
        if (apostrophePosition < 1 || apostrophePosition >= lowerCasedText.length() - 1 || lowerCasedText.startsWith("n't")) {
            return null;
        }
        String letterAfterApostrophe = lowerCasedText.substring(apostrophePosition + 1, apostrophePosition + 2);
        if (!lettersAfterApostropheForMiddleOfContraction.contains(letterAfterApostrophe)) {
            return null;
        }
        int subseqentNonAlphaNum = TokenizerHelper.findNextNonAlphaNum(lowerCasedText, apostrophePosition + 1);
        String restStartingWithApostrophe = lowerCasedText.substring(apostrophePosition, subseqentNonAlphaNum);
        char prev = lowerCasedText.charAt(apostrophePosition - 1);
        for (String s : possibleContractionEndings) {
            int lenAfterApostrophe = s.length() - 1;
            if (s.equals("n't")) {
                --lenAfterApostrophe;
            }
            if (lowerCasedText.length() < apostrophePosition + lenAfterApostrophe) continue;
            if (s.equals("n't") && prev == 'n' && lowerCasedText.charAt(apostrophePosition + 1) == 't' && lowerCasedText.length() == apostrophePosition + 1 + 1) {
                ContractionResult contractionResult = new ContractionResult();
                contractionResult.setContractionTokenLen(3);
                contractionResult.setWordTokenLen(apostrophePosition - 1 - position);
                return contractionResult;
            }
            if (restStartingWithApostrophe.equals(s)) {
                ContractionResult contractionResult = new ContractionResult();
                contractionResult.setContractionTokenLen(s.length());
                contractionResult.setWordTokenLen(apostrophePosition - position);
                return contractionResult;
            }
            if (lowerCasedText.length() == apostrophePosition + lenAfterApostrophe + 1) continue;
            char after = restStartingWithApostrophe.length() <= position + lenAfterApostrophe + 1 ? (char)'\u0000' : restStartingWithApostrophe.charAt(position + lenAfterApostrophe + 1);
            if (restStartingWithApostrophe.startsWith(s) && Character.isLetter(prev) && !Character.isLetter(after)) {
                ContractionResult contractionResult = new ContractionResult();
                contractionResult.setContractionTokenLen(s.length());
                contractionResult.setWordTokenLen(apostrophePosition - position);
                return contractionResult;
            }
            if (!s.equals("n't") || prev != 'n' || !restStartingWithApostrophe.startsWith("'t") || Character.isLetter(after)) continue;
            ContractionResult contractionResult = new ContractionResult();
            contractionResult.setContractionTokenLen(3);
            contractionResult.setWordTokenLen(apostrophePosition - 1 - position);
            return contractionResult;
        }
        return null;
    }

    static int getLenContractionToken(int currentPosition, String lowerCasedText) {
        return -1;
    }

    static int lenOfFirstTokenInContraction(String s) {
        Integer index = MultiTokenWordsLookup.get(s);
        if (index == null) {
            return -1;
        }
        return MultiTokenWordLenToken1[index];
    }

    static int lenOfSecondTokenInContraction(String s) {
        Integer index = MultiTokenWordsLookup.get(s);
        if (index == null) {
            return -1;
        }
        return MultiTokenWordLenToken2[index];
    }

    static int lenOfThirdTokenInContraction(String s) {
        Integer index = MultiTokenWordsLookup.get(s);
        if (index == null) {
            return -1;
        }
        return MultiTokenWordLenToken3[index];
    }

    static boolean isContractionThatStartsWithApostrophe(int currentPosition, String lowerCasedText) {
        String lowerCasedSubstring = lowerCasedText.substring(currentPosition);
        for (String s : contractionsStartingWithApostrophe) {
            if (!TokenizerHelper.startsWithWithoutBeingFollowedByLetter(lowerCasedSubstring, s)) continue;
            return true;
        }
        return false;
    }

    static boolean breakAtApostrophe(String s, int positionOfApostropheToTest) {
        if (s.length() == positionOfApostropheToTest + 1) {
            return true;
        }
        if (positionOfApostropheToTest == 0) {
            throw new UnsupportedOperationException("positionOfApostropheToTest==0");
        }
        if (ContractionsPTB.allDigits(s.substring(0, positionOfApostropheToTest)) && s.charAt(positionOfApostropheToTest + 1) == 's') {
            if (s.length() < positionOfApostropheToTest + 3) {
                return false;
            }
            char after = s.charAt(positionOfApostropheToTest + 2);
            return Character.isLetterOrDigit(after);
        }
        for (String comparison : fullWordsNotToBreakAtApostrophe) {
            if (!comparison.equals(s)) continue;
            return false;
        }
        return true;
    }

    static boolean allDigits(String s) {
        if (s == null || s.length() < 1) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static int tokenLengthCheckingForSingleQuoteWordsToKeepTogether(String lowerCasedText) {
        if (lowerCasedText == null) {
            throw new UnsupportedOperationException("no quote/apostrophe char found in (null)");
        }
        int firstBreak = lowerCasedText.indexOf(39);
        if (firstBreak < 0) {
            throw new UnsupportedOperationException("no quote/apostrophe char found in '" + lowerCasedText + "'");
        }
        if (firstBreak == 0) {
            return -1;
        }
        if (firstBreak + 1 == lowerCasedText.length()) {
            return firstBreak;
        }
        int secondBreak = TokenizerHelper.findNextNonAlphaNum(lowerCasedText, firstBreak + 1);
        if (ContractionsPTB.breakAtApostrophe(lowerCasedText, firstBreak)) {
            return firstBreak;
        }
        if (secondBreak == lowerCasedText.length()) {
            return secondBreak;
        }
        if (lowerCasedText.charAt(secondBreak) != '-') {
            return secondBreak;
        }
        int len = HyphenatedPTB.lenIfHyphenatedSuffix(lowerCasedText, secondBreak);
        if (len > 0) {
            return secondBreak + len;
        }
        return secondBreak;
    }

    public static void main(String[] args) {
        ContractionsPTB.test_getLengthIfNextApostIsMiddleOfContraction();
        for (int i = 0; i < MultiTokenWords.length; ++i) {
            String s = MultiTokenWords[i];
            String SPACE = " ";
            System.out.println(s.substring(0, MultiTokenWordLenToken1[i]) + SPACE + s.substring(MultiTokenWordLenToken1[i], MultiTokenWordLenToken1[i] + MultiTokenWordLenToken2[i]) + SPACE + s.substring(MultiTokenWordLenToken1[i] + MultiTokenWordLenToken2[i]) + SPACE + s.substring(MultiTokenWordLenToken3[i] + MultiTokenWordLenToken3[i]));
        }
    }

    static {
        for (int i = 0; i < MultiTokenWords.length; ++i) {
            MultiTokenWordsLookup.put(MultiTokenWords[i], i);
        }
        possibleContractionEndings = new String[]{"'s", "'ve", "'re", "'ll", "'d", "'n", "n't"};
        lettersAfterApostropheForMiddleOfContraction = "";
        for (String s : possibleContractionEndings) {
            int indexLetterAfter = s.indexOf(39) + 1;
            lettersAfterApostropheForMiddleOfContraction = lettersAfterApostropheForMiddleOfContraction + s.charAt(indexLetterAfter);
        }
        contractionsStartingWithApostrophe = new String[]{"'tis", "'twas"};
        fullWordsNotToBreakAtApostrophe = new String[]{"p'yongyang"};
    }
}

