/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.Collection;
import java.util.HashSet;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.cas.FSArray;

public final class IdentifiedAnnotationUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"IdentifiedAnnotationUtil");
    public static final String CTAKES_SNOMED_CODING_SCHEME = "SNOMED";
    public static final String CTAKES_RXNORM_CODING_SCHEME = "RXNORM";
    private static final FeatureStructure[] EMPTY_FEATURE_ARRAY = new FeatureStructure[0];

    private IdentifiedAnnotationUtil() {
    }

    private static FeatureStructure[] getOntologyConcepts(IdentifiedAnnotation annotation) {
        FSArray ontologyConcepts = annotation.getOntologyConceptArr();
        if (ontologyConcepts == null) {
            return EMPTY_FEATURE_ARRAY;
        }
        return ontologyConcepts.toArray();
    }

    public static Collection<UmlsConcept> getUmlsConcepts(IdentifiedAnnotation annotation) {
        FeatureStructure[] ontologyConcepts = IdentifiedAnnotationUtil.getOntologyConcepts(annotation);
        HashSet<UmlsConcept> umlsConcepts = new HashSet<UmlsConcept>(ontologyConcepts.length);
        for (FeatureStructure ontologyConcept : ontologyConcepts) {
            if (!(ontologyConcept instanceof UmlsConcept)) continue;
            umlsConcepts.add((UmlsConcept)ontologyConcept);
        }
        return umlsConcepts;
    }

    public static Collection<String> getUmlsCuis(IdentifiedAnnotation annotation) {
        FeatureStructure[] ontologyConcepts = IdentifiedAnnotationUtil.getOntologyConcepts(annotation);
        HashSet<String> cuis = new HashSet<String>(ontologyConcepts.length);
        for (FeatureStructure ontologyConcept : ontologyConcepts) {
            if (!(ontologyConcept instanceof UmlsConcept)) continue;
            UmlsConcept umlsConcept = (UmlsConcept)ontologyConcept;
            String cui = umlsConcept.getCui();
            cuis.add(cui);
        }
        return cuis;
    }

    public static Collection<String> getSnomedCodes(IdentifiedAnnotation annotation) {
        FeatureStructure[] ontologyConcepts = IdentifiedAnnotationUtil.getOntologyConcepts(annotation);
        HashSet<String> snomeds = new HashSet<String>();
        for (FeatureStructure featureStructure : ontologyConcepts) {
            String codingScheme;
            String code;
            OntologyConcept ontologyConcept = (OntologyConcept)featureStructure;
            if (ontologyConcept instanceof UmlsConcept || (code = ontologyConcept.getCode()) == null || code.isEmpty() || (codingScheme = ontologyConcept.getCodingScheme()) == null || !CTAKES_SNOMED_CODING_SCHEME.equalsIgnoreCase(codingScheme.trim())) continue;
            snomeds.add(code);
        }
        return snomeds;
    }

    public static Collection<String> getRxNormCodes(IdentifiedAnnotation annotation) {
        FeatureStructure[] ontologyConcepts = IdentifiedAnnotationUtil.getOntologyConcepts(annotation);
        HashSet<String> rxNorms = new HashSet<String>();
        for (FeatureStructure featureStructure : ontologyConcepts) {
            String codingScheme;
            String code;
            OntologyConcept ontologyConcept = (OntologyConcept)featureStructure;
            if (ontologyConcept instanceof UmlsConcept || (code = ontologyConcept.getCode()) == null || code.isEmpty() || (codingScheme = ontologyConcept.getCodingScheme()) == null || !CTAKES_RXNORM_CODING_SCHEME.equalsIgnoreCase(codingScheme.trim())) continue;
            rxNorms.add(code);
        }
        return rxNorms;
    }
}

