/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.sql.Timestamp;
import org.apache.ctakes.typesystem.type.structured.Metadata;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceProcessException;

public final class SourceMetadataUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"SourceMetadataUtil");

    private SourceMetadataUtil() {
    }

    public static long getPatientNum(JCas jcas) {
        Metadata metadata = SourceMetadataUtil.getMetadata(jcas);
        if (metadata == null) {
            return -1L;
        }
        return metadata.getPatientID();
    }

    private static Metadata getMetadata(JCas jcas) {
        FSIterator itr = jcas.getJFSIndexRepository().getAllIndexedFS(Metadata.type);
        if (itr == null || !itr.hasNext()) {
            return null;
        }
        return (Metadata)itr.next();
    }

    public static SourceData getSourceData(JCas jcas) {
        Metadata metadata = SourceMetadataUtil.getMetadata(jcas);
        if (metadata == null) {
            return null;
        }
        return metadata.getSourceData();
    }

    public static long getInstanceNum(SourceData sourcedata) throws ResourceProcessException {
        long instanceNum;
        String instance = sourcedata.getSourceInstanceId();
        if (instance == null || instance.isEmpty()) {
            return -1L;
        }
        try {
            instanceNum = Long.parseLong(instance);
        }
        catch (NumberFormatException nfE) {
            throw new ResourceProcessException((Throwable)nfE);
        }
        return instanceNum;
    }

    public static int getEncounterNum(SourceData sourcedata) throws ResourceProcessException {
        int encounterNum;
        String encounter = sourcedata.getSourceEncounterId();
        try {
            encounterNum = Integer.parseInt(encounter);
        }
        catch (NumberFormatException nfE) {
            throw new ResourceProcessException((Throwable)nfE);
        }
        return encounterNum;
    }

    public static String getProviderId(SourceData sourcedata) {
        return sourcedata.getAuthorSpecialty();
    }

    public static Timestamp getStartDate(SourceData sourcedata) {
        String sourceDate = sourcedata.getSourceOriginalDate();
        return Timestamp.valueOf(sourceDate);
    }
}

