/*
 * Decompiled with CFR 0.152.
 */
package org.xqdoc.conversion;

import java.util.Date;
import java.util.HashSet;
import org.xqdoc.conversion.XQDocComment;

public class XQDocXML {
    private static final String XQDOC_PREFIX = "xqdoc:";
    private static final String XQDOC_TAG = "xqdoc";
    private static final String XQDOC_CONTROL_TAG = "control";
    private static final String XQDOC_DATE_TAG = "date";
    private static final String XQDOC_VERSION_TAG = "version";
    private static final String XQDOC_MODULE_TAG = "module";
    private static final String XQDOC_URI_TAG = "uri";
    private static final String XQDOC_VARIABLES_TAG = "variables";
    private static final String XQDOC_VARIABLE_TAG = "variable";
    private static final String XQDOC_IMPORTS_TAG = "imports";
    private static final String XQDOC_IMPORT_TAG = "import";
    private static final String XQDOC_FUNCTIONS_TAG = "functions";
    private static final String XQDOC_FUNCTION_TAG = "function";
    private static final String XQDOC_NAME_TAG = "name";
    private static final String XQDOC_SIGNATURE_TAG = "signature";
    private static final String XQDOC_BODY_TAG = "body";
    private static final String XQDOC_INVOKED_TAG = "invoked";
    private static final String XQDOC_REFER_VAR_TAG = "ref-variable";
    private String xqDocNamespace;
    private StringBuffer xmlControl = new StringBuffer();
    private StringBuffer xmlModule = new StringBuffer();
    private StringBuffer xmlImport = new StringBuffer();
    private StringBuffer xmlVariable = new StringBuffer();
    private StringBuffer xmlFunction = new StringBuffer();

    public XQDocXML(String xqDocNamespace) {
        this.xqDocNamespace = xqDocNamespace;
    }

    public void buildControlSection(String version) {
        this.xmlControl.append(XQDocXML.buildBeginTag(XQDOC_CONTROL_TAG));
        this.xmlControl.append(XQDocXML.buildBeginTag(XQDOC_DATE_TAG));
        this.xmlControl.append(new Date().toString());
        this.xmlControl.append(XQDocXML.buildEndTag(XQDOC_DATE_TAG));
        this.xmlControl.append(XQDocXML.buildBeginTag(XQDOC_VERSION_TAG));
        this.xmlControl.append(version);
        this.xmlControl.append(XQDocXML.buildEndTag(XQDOC_VERSION_TAG));
        this.xmlControl.append(XQDocXML.buildEndTag(XQDOC_CONTROL_TAG));
    }

    public void buildLibraryModuleSection(String uri, String commonName, XQDocComment comment, String moduleBody) {
        this.xmlModule.append("<xqdoc:module type='library'>");
        this.xmlModule.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
        this.xmlModule.append(uri);
        this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
        if (commonName != null) {
            this.xmlModule.append(XQDocXML.buildBeginTag(XQDOC_NAME_TAG));
            this.xmlModule.append(commonName);
            this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_NAME_TAG));
        }
        this.xmlModule.append(comment.getXML());
        if (moduleBody != null) {
            this.xmlModule.append("<xqdoc:body xml:space='preserve'>");
            this.xmlModule.append(XQDocXML.encodeXML(moduleBody));
            this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_BODY_TAG));
        }
        this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_MODULE_TAG));
    }

    public void buildMainModuleSection(String uri, String commonName, XQDocComment comment, String moduleBody) {
        this.xmlModule.append("<xqdoc:module type='main'>");
        this.xmlModule.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
        this.xmlModule.append(uri);
        this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
        if (commonName != null) {
            this.xmlModule.append(XQDocXML.buildBeginTag(XQDOC_NAME_TAG));
            this.xmlModule.append(commonName);
            this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_NAME_TAG));
        }
        this.xmlModule.append(comment.getXML());
        if (moduleBody != null) {
            this.xmlModule.append("<xqdoc:body xml:space='preserve'>");
            this.xmlModule.append(XQDocXML.encodeXML(moduleBody));
            this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_BODY_TAG));
        }
        this.xmlModule.append(XQDocXML.buildEndTag(XQDOC_MODULE_TAG));
    }

    public void buildImportSection(String uri, XQDocComment comment) {
        this.xmlImport.append(XQDocXML.buildBeginTag(XQDOC_IMPORT_TAG));
        this.xmlImport.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
        this.xmlImport.append(uri);
        this.xmlImport.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
        this.xmlImport.append(comment.getXML());
        this.xmlImport.append(XQDocXML.buildEndTag(XQDOC_IMPORT_TAG));
    }

    public void buildVariableSection(String uri, XQDocComment comment) {
        this.xmlVariable.append(XQDocXML.buildBeginTag(XQDOC_VARIABLE_TAG));
        this.xmlVariable.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
        this.xmlVariable.append(uri);
        this.xmlVariable.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
        this.xmlVariable.append(comment.getXML());
        this.xmlVariable.append(XQDocXML.buildEndTag(XQDOC_VARIABLE_TAG));
    }

    public void buildFunctionSection(String functionName, String functionSignature, XQDocComment comment, String functionBody, HashSet invokedFunctions, HashSet referencedVariables) {
        this.xmlFunction.append(XQDocXML.buildBeginTag(XQDOC_FUNCTION_TAG));
        this.xmlFunction.append(comment.getXML());
        this.xmlFunction.append(XQDocXML.buildBeginTag(XQDOC_NAME_TAG));
        this.xmlFunction.append(functionName);
        this.xmlFunction.append(XQDocXML.buildEndTag(XQDOC_NAME_TAG));
        if (functionSignature != null) {
            this.xmlFunction.append(XQDocXML.buildBeginTag(XQDOC_SIGNATURE_TAG));
            this.xmlFunction.append(functionSignature);
            this.xmlFunction.append(XQDocXML.buildEndTag(XQDOC_SIGNATURE_TAG));
        }
        this.xmlFunction.append(this.buildInvokedFunctions(invokedFunctions));
        this.xmlFunction.append(this.buildReferencedVariables(referencedVariables));
        if (functionBody != null) {
            this.xmlFunction.append("<xqdoc:body xml:space='preserve'>");
            this.xmlFunction.append(XQDocXML.encodeXML(functionBody));
            this.xmlFunction.append(XQDocXML.buildEndTag(XQDOC_BODY_TAG));
        }
        this.xmlFunction.append(XQDocXML.buildEndTag(XQDOC_FUNCTION_TAG));
    }

    private String buildReferencedVariables(HashSet referencedVariables) {
        StringBuffer rsp = new StringBuffer();
        if (referencedVariables.size() > 0) {
            for (String entry : referencedVariables) {
                String namespace = null;
                String localName = null;
                String[] tmp = entry.split(" ", 2);
                namespace = tmp[0];
                localName = tmp[1];
                rsp.append(XQDocXML.buildBeginTag(XQDOC_REFER_VAR_TAG));
                rsp.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
                rsp.append(namespace);
                rsp.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
                rsp.append(XQDocXML.buildBeginTag(XQDOC_NAME_TAG));
                rsp.append(localName);
                rsp.append(XQDocXML.buildEndTag(XQDOC_NAME_TAG));
                rsp.append(XQDocXML.buildEndTag(XQDOC_REFER_VAR_TAG));
            }
        }
        return rsp.toString();
    }

    private String buildInvokedFunctions(HashSet invokedFunctions) {
        StringBuffer rsp = new StringBuffer();
        if (invokedFunctions.size() > 0) {
            for (String entry : invokedFunctions) {
                String namespace = null;
                String localName = null;
                String[] tmp = entry.split(" ", 2);
                namespace = tmp[0];
                localName = tmp[1];
                rsp.append(XQDocXML.buildBeginTag(XQDOC_INVOKED_TAG));
                rsp.append(XQDocXML.buildBeginTag(XQDOC_URI_TAG));
                rsp.append(namespace);
                rsp.append(XQDocXML.buildEndTag(XQDOC_URI_TAG));
                rsp.append(XQDocXML.buildBeginTag(XQDOC_NAME_TAG));
                rsp.append(localName);
                rsp.append(XQDocXML.buildEndTag(XQDOC_NAME_TAG));
                rsp.append(XQDocXML.buildEndTag(XQDOC_INVOKED_TAG));
            }
        }
        return rsp.toString();
    }

    public String getXML() {
        StringBuffer rsp = new StringBuffer();
        rsp.append(XQDocXML.buildBeginTagWithNamespace(XQDOC_TAG, this.xqDocNamespace));
        rsp.append(this.xmlControl);
        rsp.append(this.xmlModule);
        if (this.xmlImport.length() > 0) {
            rsp.append(XQDocXML.buildBeginTag(XQDOC_IMPORTS_TAG));
            rsp.append(this.xmlImport);
            rsp.append(XQDocXML.buildEndTag(XQDOC_IMPORTS_TAG));
        }
        if (this.xmlVariable.length() > 0) {
            rsp.append(XQDocXML.buildBeginTag(XQDOC_VARIABLES_TAG));
            rsp.append(this.xmlVariable);
            rsp.append(XQDocXML.buildEndTag(XQDOC_VARIABLES_TAG));
        }
        if (this.xmlFunction.length() > 0) {
            rsp.append(XQDocXML.buildBeginTag(XQDOC_FUNCTIONS_TAG));
            rsp.append(this.xmlFunction);
            rsp.append(XQDocXML.buildEndTag(XQDOC_FUNCTIONS_TAG));
        }
        rsp.append(XQDocXML.buildEndTag(XQDOC_TAG));
        return rsp.toString();
    }

    public static String buildBeginTagWithNamespace(String name, String namespace) {
        return "<xqdoc:" + name + " xmlns:xqdoc='" + namespace + "'>";
    }

    public static String buildBeginTag(String name) {
        return "<xqdoc:" + name + ">";
    }

    public static String buildEndTag(String name) {
        return "</xqdoc:" + name + ">";
    }

    public static String encodeXML(String input) {
        String tmp = input.replaceAll("&", "&amp;");
        tmp = tmp.replaceAll("<", "&lt;");
        tmp = tmp.replaceAll(">", "&gt;");
        return tmp;
    }
}

