/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultNotSupportedException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.impl.AnalysisProcessData_impl;
import org.apache.uima.analysis_engine.impl.AnnotatorContext_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.impl.UimaContext_ImplBase;
import org.apache.uima.impl.Util;
import org.apache.uima.internal.util.UUIDGenerator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.uimacpp.UimacppAnalysisComponent;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UimacppAnalysisEngineImpl
extends AnalysisEngineImplBase
implements AnalysisEngine {
    private static final Class<UimacppAnalysisEngineImpl> CLASS_NAME = UimacppAnalysisEngineImpl.class;
    private ResourceCreationSpecifier mDescription;
    private UimacppAnalysisComponent mAnnotator;
    private AnnotatorContext_impl mAnnotatorContext;
    private boolean mSofaAware = false;
    private boolean mVerificationMode = false;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof ResourceCreationSpecifier)) {
            return false;
        }
        if (!(aSpecifier instanceof AnalysisEngineDescription) && !(aSpecifier instanceof CasConsumerDescription)) {
            return false;
        }
        this.mDescription = (ResourceCreationSpecifier)aSpecifier;
        String fwImpl = this.mDescription.getFrameworkImplementation();
        if (!fwImpl.startsWith("org.apache.uima.cpp")) {
            return false;
        }
        if (this.mDescription instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)this.mDescription).isPrimitive()) {
            try {
                this.mDescription.validate(this.getResourceManager());
            }
            catch (ResourceConfigurationException e) {
                throw new ResourceInitializationException(e);
            }
            this.mergeDelegateAnalysisEngineMetaData();
        }
        ProcessingResourceMetaData md = (ProcessingResourceMetaData)this.mDescription.getMetaData();
        if (this.mDescription instanceof AnalysisEngineDescription && ((AnalysisEngineDescription)this.mDescription).isPrimitive()) {
            try {
                md.resolveImports();
            }
            catch (InvalidXMLException e1) {
                throw new ResourceInitializationException(e1);
            }
        }
        super.initialize(aSpecifier, aAdditionalParams);
        this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_begin__CONFIG", md.getName());
        this.normalizeIsoLangCodes(md);
        AnalysisEngineMetaData mdCopy = (AnalysisEngineMetaData)md.clone();
        if (mdCopy.getUUID() == null) {
            mdCopy.setUUID(UUIDGenerator.generate());
        }
        this.setMetaData(mdCopy);
        if (aAdditionalParams == null) {
            aAdditionalParams = Collections.emptyMap();
        }
        this.mVerificationMode = aAdditionalParams.containsKey("VERIFICATION_MODE");
        this.mSofaAware = this.getAnalysisEngineMetaData().isSofaAware();
        this.initializeAnalysisComponent();
        this.resetResultSpecificationToDefault();
        this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_successful__CONFIG", md.getName());
        return true;
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
        if (aResultSpec == null) {
            this.resetResultSpecificationToDefault();
        } else if (this.mAnnotator != null) {
            this.mAnnotator.setResultSpecification(aResultSpec);
        }
    }

    @Override
    public void destroy() {
        if (this.mAnnotator != null) {
            this.mAnnotator.destroy();
        }
        this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_destroyed__CONFIG", this.getMetaData().getName());
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        this.enterProcess();
        try {
            this.callAnalysisComponentProcess(aCAS);
            TafAnalysisComponentCasIterator tafAnalysisComponentCasIterator = new TafAnalysisComponentCasIterator(this.mAnnotator);
            return tafAnalysisComponentCasIterator;
        }
        finally {
            this.exitProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.enterBatchProcessComplete();
        try {
            this.mAnnotator.batchProcessComplete();
        }
        finally {
            this.exitBatchProcessComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.enterCollectionProcessComplete();
        try {
            this.mAnnotator.collectionProcessComplete();
        }
        finally {
            this.exitCollectionProcessComplete();
        }
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        super.reconfigure();
        this.mAnnotator.reconfigure();
    }

    protected void callAnalysisComponentProcess(CAS aCAS) throws AnalysisEngineProcessException {
        String resourceName = this.getMetaData().getName();
        this.getLogger().logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", resourceName);
        try {
            try {
                this.enableProhibitedAnnotatorCasFunctions(aCAS, false);
                CASImpl view = Util.getStartingView(aCAS, this.mSofaAware, this.getUimaContextAdmin().getComponentInfo());
                Class<CAS> requiredInterface = this.mAnnotator.getRequiredCasInterface();
                AbstractCas casToPass = this.getCasManager().getCasInterface(view, requiredInterface);
                this.mAnnotator.process(casToPass);
                this.getMBean().incrementCASesProcessed();
            }
            catch (Exception e) {
                if (e instanceof AnalysisEngineProcessException) {
                    throw e;
                }
                throw new AnalysisEngineProcessException("annotator_exception", null, e);
            }
            finally {
                this.enableProhibitedAnnotatorCasFunctions(aCAS, true);
            }
            this.getLogger().logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", resourceName);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "", e);
            if (e instanceof AnalysisEngineProcessException) {
                throw (AnalysisEngineProcessException)e;
            }
            throw new AnalysisEngineProcessException(e);
        }
    }

    protected void initializeAnalysisComponent() throws ResourceInitializationException {
        UimaContextAdmin uimaContext = this.getUimaContextAdmin();
        uimaContext.setLogger(UIMAFramework.getLogger(UimacppAnalysisComponent.class));
        this.mAnnotatorContext = new AnnotatorContext_impl(uimaContext);
        if (!this.mVerificationMode) {
            this.mAnnotator = new UimacppAnalysisComponent(this.mDescription, this);
            this.getUimaContextAdmin().defineCasPool(this.mAnnotator.getCasInstancesRequired(), this.getPerformanceTuningSettings(), this.mSofaAware);
            this.mAnnotator.initialize(uimaContext);
        }
    }

    protected void mergeDelegateAnalysisEngineMetaData() throws ResourceInitializationException {
        TypeSystemDescription aggTypeSystem = CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems((AnalysisEngineDescription)this.mDescription, this.getResourceManager());
        TypePriorities aggTypePriorities = CasCreationUtils.mergeDelegateAnalysisEngineTypePriorities((AnalysisEngineDescription)this.mDescription, this.getResourceManager());
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeDelegateAnalysisEngineFsIndexCollections((AnalysisEngineDescription)this.mDescription, this.getResourceManager());
        ProcessingResourceMetaData aggregateMD = (ProcessingResourceMetaData)this.mDescription.getMetaData();
        aggregateMD.setTypeSystem(aggTypeSystem);
        aggregateMD.setTypePriorities(aggTypePriorities);
        aggregateMD.setFsIndexCollection(aggIndexColl);
    }

    protected void enableProhibitedAnnotatorCasFunctions(CAS aCAS, boolean aEnable) {
        if (aCAS instanceof CASMgr) {
            ((CASMgr)((Object)aCAS)).enableReset(aEnable);
        }
    }

    protected CAS callAnalysisComponentNext() throws AnalysisEngineProcessException, ResultNotSupportedException {
        try {
            AbstractCas absCas = this.mAnnotator.next();
            this.getMBean().incrementCASesProcessed();
            ((UimaContext_ImplBase)this.getUimaContext()).returnedCAS(absCas);
            CAS casToReturn = absCas instanceof JCas ? ((JCas)absCas).getCas() : (CAS)absCas;
            casToReturn = casToReturn.getView("_InitialView");
            return casToReturn;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "", e);
            if (e instanceof AnalysisEngineProcessException) {
                throw (AnalysisEngineProcessException)e;
            }
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Deprecated
    protected AnalysisProcessData_impl createAnalysisProcessData() {
        try {
            return new AnalysisProcessData_impl(this.newCAS(), this.getPerformanceTuningSettings());
        }
        catch (ResourceInitializationException e) {
            throw new UIMARuntimeException(e);
        }
    }

    protected AnalysisComponent _getAnnotator() {
        return this.mAnnotator;
    }

    protected AnnotatorContext_impl _getAnnotatorContext() {
        return this.mAnnotatorContext;
    }

    protected Map<String, ResourceSpecifier> _getComponentCasProcessorSpecifierMap() {
        try {
            return ((AnalysisEngineDescription)this.mDescription).getDelegateAnalysisEngineSpecifiers();
        }
        catch (InvalidXMLException e) {
            throw new UIMARuntimeException(e);
        }
    }

    class TafAnalysisComponentCasIterator
    implements CasIterator {
        private AnalysisComponent mAnalysisComponent;

        TafAnalysisComponentCasIterator(AnalysisComponent aAnalysisComponent) {
            this.mAnalysisComponent = aAnalysisComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() throws AnalysisEngineProcessException {
            UimacppAnalysisEngineImpl.this.enterProcess();
            try {
                boolean bl = this.mAnalysisComponent.hasNext();
                return bl;
            }
            finally {
                UimacppAnalysisEngineImpl.this.exitProcess();
            }
        }

        public CAS next() throws AnalysisEngineProcessException {
            UimacppAnalysisEngineImpl.this.enterProcess();
            try {
                boolean analysisComponentHasNext = this.mAnalysisComponent.hasNext();
                if (!analysisComponentHasNext) {
                    throw new UIMA_IllegalStateException("no_next_cas", new Object[0]);
                }
                try {
                    CAS cas;
                    CAS cAS = cas = UimacppAnalysisEngineImpl.this.callAnalysisComponentNext();
                    return cAS;
                }
                catch (Exception e) {
                    if (e instanceof AnalysisEngineProcessException) {
                        throw (AnalysisEngineProcessException)e;
                    }
                    throw new AnalysisEngineProcessException(e);
                }
            }
            finally {
                UimacppAnalysisEngineImpl.this.exitProcess();
            }
        }

        public void release() {
        }
    }
}

