/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeSystemUtils {
    private static final String NAMESPACE_SEPARATOR_AS_STRING = ".";

    public static boolean isIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (s == null || len == 0) {
            return false;
        }
        int pos = 0;
        if (!TypeSystemUtils.isIdentifierStart(s.charAt(pos))) {
            return false;
        }
        ++pos;
        while (pos < len) {
            if (!TypeSystemUtils.isIdentifierChar(s.charAt(pos))) {
                return false;
            }
            ++pos;
        }
        return true;
    }

    static boolean isNonQualifiedName(String s) {
        return TypeSystemUtils.isIdentifier(s);
    }

    static boolean isIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    static boolean isIdentifierChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    static boolean isTypeName(String name) {
        StringTokenizer tok = new StringTokenizer(name, NAMESPACE_SEPARATOR_AS_STRING, true);
        while (tok.hasMoreTokens()) {
            if (!TypeSystemUtils.isIdentifier(tok.nextToken())) {
                return false;
            }
            if (!tok.hasMoreTokens()) continue;
            if (!tok.nextToken().equals(NAMESPACE_SEPARATOR_AS_STRING)) {
                return false;
            }
            if (tok.hasMoreTokens()) continue;
            return false;
        }
        return true;
    }

    static boolean isTypeNameSpaceName(String name) {
        return TypeSystemUtils.isTypeName(name);
    }

    public static final PathValid isPathValid(Type type, List<String> path) {
        Stack<String> fStack = new Stack<String>();
        for (int i = path.size() - 1; i >= 0; --i) {
            fStack.push(path.get(i));
        }
        return TypeSystemUtils.isPathValid(type, fStack, PathValid.ALWAYS);
    }

    private static final PathValid isPathValid(Type type, Stack<String> path, PathValid status) {
        if (path.isEmpty()) {
            return status;
        }
        String fName = path.pop();
        Feature feat = type.getFeatureByBaseName(fName);
        if (feat != null) {
            return TypeSystemUtils.isPathValid(feat.getRange(), path, status);
        }
        ArrayList<Type> subtypes = new ArrayList<Type>();
        TypeSystemUtils.getFeatureDefiningSubtypes(type, fName, subtypes);
        for (int i = 0; i < subtypes.size(); ++i) {
            Type nextType = ((Type)subtypes.get(i)).getFeatureByBaseName(fName).getRange();
            PathValid newStatus = TypeSystemUtils.isPathValid(nextType, path, PathValid.POSSIBLE);
            if (newStatus != PathValid.POSSIBLE) continue;
            return PathValid.POSSIBLE;
        }
        return PathValid.NEVER;
    }

    private static final void getFeatureDefiningSubtypes(Type type, String fName, List<Type> types) {
        TypeSystem ts = ((TypeImpl)type).getTypeSystem();
        List<Type> subtypes = ts.getDirectSubtypes(type);
        for (int i = 0; i < subtypes.size(); ++i) {
            Type subtype = subtypes.get(i);
            if (subtype.getFeatureByBaseName(fName) != null) {
                types.add(subtypes.get(i));
                continue;
            }
            TypeSystemUtils.getFeatureDefiningSubtypes(subtype, fName, types);
        }
    }

    public static final int classifyType(Type type) {
        LowLevelTypeSystem llts = ((TypeImpl)type).getTypeSystem().getLowLevelTypeSystem();
        return llts.ll_getTypeClass(llts.ll_getCodeForType(type));
    }

    static class ParsingError {
        private int errorCode;
        private int errorPosition;

        ParsingError() {
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public int getErrorPosition() {
            return this.errorPosition;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorPosition(int errorPosition) {
            this.errorPosition = errorPosition;
        }
    }

    static class FeatureParse
    extends TypeSystemParse {
        private TypeParse type;
        private String name;

        FeatureParse() {
        }

        public String getName() {
            return this.name;
        }

        public TypeParse getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(TypeParse type) {
            this.type = type;
        }
    }

    static class TypeParse
    extends TypeSystemParse {
        private String name;
        private NameSpaceParse nameSpace;

        TypeParse() {
        }

        TypeParse(String name) {
            this();
            this.name = name;
        }

        boolean isQualified() {
            return this.nameSpace != null;
        }

        String getName() {
            return this.name;
        }

        NameSpaceParse getNameSpace() {
            return this.nameSpace;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNameSpace(NameSpaceParse nameSpace) {
            this.nameSpace = nameSpace;
        }
    }

    static class NameSpaceParse
    extends TypeSystemParse {
        private String name;

        NameSpaceParse() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }
    }

    static abstract class TypeSystemParse {
        private ParsingError error = null;

        protected TypeSystemParse() {
        }

        boolean hasError() {
            return this.error != null;
        }

        ParsingError getError() {
            return this.error;
        }

        void setError(ParsingError error) {
            this.error = error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathValid {
        NEVER,
        POSSIBLE,
        ALWAYS;

    }
}

