/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntStack;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmiCasSerializer {
    public static final int TYPE_CLASS_INTLIST = 101;
    public static final int TYPE_CLASS_FLOATLIST = 102;
    public static final int TYPE_CLASS_STRINGLIST = 103;
    public static final int TYPE_CLASS_FSLIST = 104;
    private static final char[] URIPFX = new char[]{'h', 't', 't', 'p', ':', '/', '/', '/'};
    private static final char[] URISFX = new char[]{'.', 'e', 'c', 'o', 'r', 'e'};
    private int numChildren;
    public static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XMI_NS_URI = "http://www.omg.org/XMI";
    public static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMI_NS_PREFIX = "xmi";
    public static final String XMI_TAG_LOCAL_NAME = "XMI";
    public static final String XMI_TAG_QNAME = "xmi:XMI";
    public static final XmlElementName XMI_TAG = new XmlElementName("http://www.omg.org/XMI", "XMI", "xmi:XMI");
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String ID_ATTR_NAME = "xmi:id";
    public static final String XMI_VERSION_LOCAL_NAME = "version";
    public static final String XMI_VERSION_QNAME = "xmi:version";
    public static final String XMI_VERSION_VALUE = "2.0";
    public static final String DEFAULT_NAMESPACE_URI = "http:///uima/noNamespace.ecore";
    private TypeSystemImpl filterTypeSystem;
    private Logger logger;
    private Map<String, String> nsUriToSchemaLocationMap = null;

    public int getNumChildren() {
        return this.numChildren;
    }

    public XmiCasSerializer(TypeSystem ts, Map<String, String> nsUriToSchemaLocationMap) {
        this.filterTypeSystem = (TypeSystemImpl)ts;
        this.nsUriToSchemaLocationMap = nsUriToSchemaLocationMap;
        this.logger = UIMAFramework.getLogger(XmiCasSerializer.class);
    }

    public XmiCasSerializer(TypeSystem ts) {
        this(ts, (Map<String, String>)null);
    }

    @Deprecated
    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext, Map<String, String> nsUriToSchemaLocationMap) {
        this(ts, nsUriToSchemaLocationMap);
    }

    @Deprecated
    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext) {
        this(ts);
    }

    public void serialize(CAS cas, ContentHandler contentHandler) throws SAXException {
        this.serialize(cas, contentHandler, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer ser = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cas).getBaseCAS(), null, null);
        ser.serialize();
        contentHandler.endDocument();
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData sharedData) throws SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer ser = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cas).getBaseCAS(), sharedData, null);
        ser.serialize();
        contentHandler.endDocument();
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData sharedData, Marker marker) throws SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer ser = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cas).getBaseCAS(), sharedData, (MarkerImpl)marker);
        ser.serialize();
        contentHandler.endDocument();
    }

    public static void serialize(CAS aCAS, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, null, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, aTargetTypeSystem, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData) throws SAXException {
        XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(aTargetTypeSystem);
        XMLSerializer sax2xml = new XMLSerializer(aStream, aPrettyPrint);
        xmiCasSerializer.serialize(aCAS, sax2xml.getContentHandler(), null, aSharedData, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData, Marker aMarker) throws SAXException {
        XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(aTargetTypeSystem);
        XMLSerializer sax2xml = new XMLSerializer(aStream, aPrettyPrint);
        xmiCasSerializer.serialize(aCAS, sax2xml.getContentHandler(), null, aSharedData, aMarker);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmiCasDocSerializer {
        private ContentHandler ch;
        private ErrorHandler eh = null;
        private CASImpl cas;
        private IntRedBlackTree visited;
        private IntVector indexedFSs;
        private IntStack queue;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private ListUtils listUtils;
        private IntRedBlackTree arrayAndListFSs;
        private XmiSerializationSharedData sharedData;
        private XmlElementName[] xmiTypeNames;
        private Map<String, String> nsUriToPrefixMap = new HashMap<String, String>();
        private Map<String, String> uniqueStrings = new HashMap<String, String>();
        private Set<String> nsPrefixesUsed = new HashSet<String>();
        private MarkerImpl marker;
        boolean isFiltering;
        boolean isDelta;

        private XmiCasDocSerializer(ContentHandler ch, ErrorHandler eh, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker) {
            this.ch = ch;
            this.eh = eh;
            this.cas = cas;
            this.visited = new IntRedBlackTree();
            this.queue = new IntStack();
            this.indexedFSs = new IntVector();
            this.listUtils = new ListUtils(cas, XmiCasSerializer.this.logger, eh);
            this.arrayAndListFSs = new IntRedBlackTree();
            this.sharedData = sharedData;
            boolean bl = this.isFiltering = XmiCasSerializer.this.filterTypeSystem != null && XmiCasSerializer.this.filterTypeSystem != cas.getTypeSystemImpl();
            if (marker != null) {
                if (marker.isValid()) {
                    this.marker = marker;
                } else {
                    CASRuntimeException exception = new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
                    throw exception;
                }
            }
            this.isDelta = false;
            if (this.marker != null) {
                this.isDelta = true;
            }
        }

        private void reportWarning(String message) throws SAXException {
            XmiCasSerializer.this.logger.log(Level.WARNING, message);
            if (this.eh != null) {
                this.eh.warning(new SAXParseException(message, null));
            }
        }

        private boolean isVisited(int addr) {
            return this.visited.containsKey(addr);
        }

        private void serialize() throws SAXException {
            this.initTypeAndNamespaceMappings();
            int iElementCount = 1;
            this.enqueueIncoming();
            this.enqueueIndexed();
            this.enqueueNonsharedMultivaluedFS();
            this.enqueueFeaturesOfIndexed();
            iElementCount += this.indexedFSs.size();
            iElementCount += this.queue.size();
            FSIndex<FeatureStructure> sofaIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            if (!this.isDelta) {
                iElementCount += sofaIndex.size();
                if (this.sharedData != null) {
                    iElementCount += this.sharedData.getOutOfTypeSystemElements().size();
                }
            } else {
                int numViews = this.cas.getBaseSofaCount();
                for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                    FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                    if (loopIR == null || !loopIR.isModified()) continue;
                    ++iElementCount;
                }
            }
            this.workAttrs.clear();
            this.computeNamespaceDeclarationAttrs(this.workAttrs);
            this.workAttrs.addAttribute(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_VERSION_LOCAL_NAME, XmiCasSerializer.XMI_VERSION_QNAME, cdataType, XmiCasSerializer.XMI_VERSION_VALUE);
            this.startElement(XMI_TAG, this.workAttrs, iElementCount);
            this.writeNullObject();
            this.encodeIndexed();
            this.encodeQueued();
            if (!this.isDelta) {
                this.serializeOutOfTypeSystemElements();
            }
            this.writeViews();
            this.endElement(XMI_TAG);
            this.endPrefixMappings();
        }

        private void writeViews() throws SAXException {
            int numViews = this.cas.getBaseSofaCount();
            String sofaXmiId = null;
            FeatureStructureImpl sofa = null;
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                int[] fsarray;
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (sofaNum != 1 || this.cas.isInitialSofaCreated()) {
                    sofa = (FeatureStructureImpl)((Object)this.cas.getView(sofaNum).getSofa());
                    sofaXmiId = this.getXmiId(sofa.getAddress());
                }
                if (loopIR == null) continue;
                if (!this.isDelta) {
                    fsarray = loopIR.getIndexedFSs();
                    this.writeView(sofaXmiId, fsarray);
                    continue;
                }
                if (sofaNum != 1 && this.marker.isNew(sofa.getAddress())) {
                    fsarray = loopIR.getIndexedFSs();
                    this.writeView(sofaXmiId, fsarray);
                    continue;
                }
                if (!loopIR.isModified()) continue;
                this.writeView(sofaXmiId, loopIR.getAddedFSs(), loopIR.getDeletedFSs(), loopIR.getReindexedFSs());
            }
        }

        private void writeView(String sofaXmiId, int[] members) throws SAXException {
            List<String> ootsMembers;
            this.workAttrs.clear();
            if (sofaXmiId != null && sofaXmiId.length() > 0) {
                this.addAttribute(this.workAttrs, "sofa", sofaXmiId);
            }
            StringBuilder membersString = new StringBuilder();
            for (int i = 0; i < members.length; ++i) {
                String xmiId = this.getXmiId(members[i]);
                if (xmiId == null) continue;
                membersString.append(xmiId).append(' ');
            }
            if (this.sharedData != null && (ootsMembers = this.sharedData.getOutOfTypeSystemViewMembers(sofaXmiId)) != null) {
                Iterator<String> iter = ootsMembers.iterator();
                while (iter.hasNext()) {
                    membersString.append(iter.next()).append(' ');
                }
            }
            if (membersString.length() > 0) {
                this.addAttribute(this.workAttrs, "members", membersString.substring(0, membersString.length() - 1));
            }
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.View");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        private void writeView(String sofaXmiId, int[] added, int[] deleted, int[] reindexed) throws SAXException {
            this.workAttrs.clear();
            if (sofaXmiId != null && sofaXmiId.length() > 0) {
                this.addAttribute(this.workAttrs, "sofa", sofaXmiId);
            }
            StringBuilder addedString = new StringBuilder();
            for (int i = 0; i < added.length; ++i) {
                String xmiId = this.getXmiId(added[i]);
                if (xmiId == null) continue;
                addedString.append(xmiId).append(' ');
            }
            if (addedString.length() > 0) {
                this.addAttribute(this.workAttrs, "added_members", addedString.substring(0, addedString.length() - 1));
            }
            StringBuilder deletedString = new StringBuilder();
            for (int i = 0; i < deleted.length; ++i) {
                String xmiId = this.getXmiId(deleted[i]);
                if (xmiId == null) continue;
                deletedString.append(xmiId).append(' ');
            }
            if (deletedString.length() > 0) {
                this.addAttribute(this.workAttrs, "deleted_members", deletedString.substring(0, deletedString.length() - 1));
            }
            StringBuilder reindexedString = new StringBuilder();
            for (int i = 0; i < reindexed.length; ++i) {
                String xmiId = this.getXmiId(reindexed[i]);
                if (xmiId == null) continue;
                reindexedString.append(xmiId).append(' ');
            }
            if (reindexedString.length() > 0) {
                this.addAttribute(this.workAttrs, "reindexed_members", reindexedString.substring(0, reindexedString.length() - 1));
            }
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.View");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        private void writeNullObject() throws SAXException {
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, "0");
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.NULL");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        private void computeNamespaceDeclarationAttrs(AttributesImpl workAttrs2) throws SAXException {
            for (Map.Entry<String, String> entry : this.nsUriToPrefixMap.entrySet()) {
                String string = entry.getKey();
                String prefix = entry.getValue();
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, prefix, "xmlns:" + prefix, cdataType, string);
                this.ch.startPrefixMapping(prefix, string);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, "xsi", "xmlns:xsi", cdataType, XmiCasSerializer.XSI_NS_URI);
                this.ch.startPrefixMapping("xsi", XmiCasSerializer.XSI_NS_URI);
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, String> entry : XmiCasSerializer.this.nsUriToSchemaLocationMap.entrySet()) {
                    buf.append(entry.getKey()).append(' ').append(entry.getValue()).append(' ');
                }
                this.workAttrs.addAttribute(XmiCasSerializer.XSI_NS_URI, "xsi", "xsi:schemaLocation", cdataType, buf.toString());
            }
        }

        private void endPrefixMappings() throws SAXException {
            for (Map.Entry<String, String> entry : this.nsUriToPrefixMap.entrySet()) {
                String prefix = entry.getValue();
                this.ch.endPrefixMapping(prefix);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.ch.endPrefixMapping("xsi");
            }
        }

        private void enqueueIncoming() {
            if (this.sharedData == null) {
                return;
            }
            int[] fsAddrs = this.sharedData.getAllFsAddressesInIdMap();
            for (int i = 0; i < fsAddrs.length; ++i) {
                if (this.isDelta && !this.marker.isModified(fsAddrs[i])) continue;
                this.enqueueIndexedFs(fsAddrs[i]);
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getBaseIndexRepository();
            int[] fsarray = ir.getIndexedFSs();
            for (int k = 0; k < fsarray.length; ++k) {
                this.enqueueIndexedFs(fsarray[k]);
            }
            int numViews = this.cas.getBaseSofaCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (loopIR == null) continue;
                fsarray = loopIR.getIndexedFSs();
                for (int k = 0; k < fsarray.length; ++k) {
                    this.enqueueIndexedFs(fsarray[k]);
                }
            }
        }

        private void enqueueNonsharedMultivaluedFS() {
            if (this.sharedData == null || !this.isDelta) {
                return;
            }
            int[] fsAddrs = this.sharedData.getNonsharedMulitValuedFSs();
            for (int i = 0; i < fsAddrs.length; ++i) {
                int encompassingFS;
                if (!this.marker.isModified(fsAddrs[i]) || this.isVisited(encompassingFS = this.sharedData.getEncompassingFS(fsAddrs[i]))) continue;
                this.visited.put(encompassingFS, encompassingFS);
                this.indexedFSs.add(encompassingFS);
            }
        }

        private void enqueueFeaturesOfIndexed() throws SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                int addr = this.indexedFSs.get(i);
                int heapVal = this.cas.getHeapValue(addr);
                this.enqueueFeatures(addr, heapVal);
            }
        }

        private void enqueueIndexedFs(int addr) {
            if (this.isVisited(addr)) {
                return;
            }
            if (this.isDelta && !this.marker.isNew(addr) && !this.marker.isModified(addr)) {
                return;
            }
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(this.cas.getHeapValue(addr)).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return;
                }
            }
            this.visited.put(addr, addr);
            this.indexedFSs.add(addr);
        }

        private void enqueue(int addr) throws SAXException {
            if (this.isVisited(addr)) {
                return;
            }
            if (this.isDelta && !this.marker.isNew(addr) && !this.marker.isModified(addr)) {
                return;
            }
            int typeCode = this.cas.getHeapValue(addr);
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(typeCode).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return;
                }
            }
            this.visited.put(addr, addr);
            this.queue.push(addr);
            this.enqueueFeatures(addr, typeCode);
            if (this.cas.isFSArrayType(typeCode)) {
                this.enqueueFSArrayElements(addr);
            }
        }

        private void enqueueFeatures(int addr, int typeCode) throws SAXException {
            boolean insideListNode = this.listUtils.isListType(typeCode);
            int[] feats = this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(typeCode);
            block5: for (int i = 0; i < feats.length; ++i) {
                int featAddr;
                int featVal;
                if (this.isFiltering) {
                    String fullFeatName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getName();
                    if (XmiCasSerializer.this.filterTypeSystem.getFeatureByFullName(fullFeatName) == null) continue;
                }
                if ((featVal = this.cas.getHeapValue(featAddr = addr + this.cas.getFeatureOffset(feats[i]))) == 0) continue;
                int fsClass = this.classifyType(this.cas.getTypeSystemImpl().range(feats[i]));
                switch (fsClass) {
                    case 8: {
                        this.enqueue(featVal);
                        continue block5;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            this.enqueue(featVal);
                            continue block5;
                        }
                        if (fsClass != 7) continue block5;
                        this.enqueueFSArrayElements(featVal);
                        continue block5;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            this.enqueue(featVal);
                            continue block5;
                        }
                        if (fsClass != 104) continue block5;
                        this.enqueueFSListElements(featVal);
                    }
                }
            }
        }

        private void enqueueFSArrayElements(int addr) throws SAXException {
            int size = this.cas.ll_getArraySize(addr);
            int pos = this.cas.getArrayStartAddress(addr);
            for (int i = 0; i < size; ++i) {
                int val = this.cas.getHeapValue(pos);
                if (val != 0) {
                    this.enqueue(val);
                }
                ++pos;
            }
        }

        private void enqueueFSListElements(int addr) throws SAXException {
            int[] addrArray = this.listUtils.fsListToAddressArray(addr);
            for (int j = 0; j < addrArray.length; ++j) {
                if (addrArray[j] == 0) continue;
                this.enqueue(addrArray[j]);
            }
        }

        private void encodeIndexed() throws SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                this.encodeFS(this.indexedFSs.get(i));
            }
        }

        private void encodeQueued() throws SAXException {
            while (!this.queue.empty()) {
                int addr = this.queue.pop();
                this.encodeFS(addr);
            }
        }

        private void encodeFS(int addr) throws SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, this.getXmiId(addr));
            int typeCode = this.cas.getHeapValue(addr);
            XmlElementName xmlElementName = this.xmiTypeNames[typeCode];
            int typeClass = this.classifyType(typeCode);
            switch (typeClass) {
                case 8: 
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    List<XmlElementNameAndContents> childElements = this.encodeFeatures(addr, this.workAttrs, typeClass != 8);
                    this.startElement(xmlElementName, this.workAttrs, childElements.size());
                    this.sendElementEvents(childElements);
                    this.endElement(xmlElementName);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.workAttrs.addAttribute("", "", "elements", cdataType, this.arrayToString(addr, typeClass));
                    this.startElement(xmlElementName, this.workAttrs, 0);
                    this.endElement(xmlElementName);
                    break;
                }
                case 6: {
                    ArrayList childElements = new ArrayList();
                    this.stringArrayToElementList("elements", addr, childElements);
                    this.startElement(xmlElementName, this.workAttrs, childElements.size());
                    this.sendElementEvents(childElements);
                    this.endElement(xmlElementName);
                    break;
                }
                default: {
                    throw new SAXException("Error classifying FS type.");
                }
            }
        }

        private String getXmiId(int addr) {
            if (addr == 0) {
                return null;
            }
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(this.cas.getHeapValue(addr)).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return null;
                }
            }
            if (this.sharedData == null) {
                return Integer.toString(addr);
            }
            return this.sharedData.getXmiId(addr);
        }

        private void sendElementEvents(List<? extends XmlElementNameAndContents> elements) throws SAXException {
            for (XmlElementNameAndContents xmlElementNameAndContents : elements) {
                if (xmlElementNameAndContents.contents != null) {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 1);
                    this.addText(xmlElementNameAndContents.contents);
                } else {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 0);
                }
                this.endElement(xmlElementNameAndContents.name);
            }
        }

        private List<XmlElementNameAndContents> encodeFeatures(int addr, AttributesImpl attrs, boolean insideListNode) throws SAXException {
            XmiSerializationSharedData.OotsElementData oed;
            ArrayList<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();
            int heapValue = this.cas.getHeapValue(addr);
            int[] feats = this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(heapValue);
            for (int i = 0; i < feats.length; ++i) {
                String attrValue;
                if (this.isFiltering) {
                    String fullFeatName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getName();
                    if (XmiCasSerializer.this.filterTypeSystem.getFeatureByFullName(fullFeatName) == null) continue;
                }
                int featAddr = addr + this.cas.getFeatureOffset(feats[i]);
                int featVal = this.cas.getHeapValue(featAddr);
                String featName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getShortName();
                int fsClass = this.classifyType(this.cas.getTypeSystemImpl().range(feats[i]));
                switch (fsClass) {
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        attrValue = this.cas.getFeatureValueAsString(addr, feats[i]);
                        break;
                    }
                    case 3: {
                        if (featVal == 0) {
                            attrValue = null;
                            break;
                        }
                        attrValue = this.cas.getStringForCode(featVal);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        attrValue = this.arrayToString(featVal, fsClass);
                        break;
                    }
                    case 6: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        this.stringArrayToElementList(featName, featVal, childElements);
                        attrValue = null;
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 104: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        attrValue = this.listToString(featVal, fsClass);
                        break;
                    }
                    case 103: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        String[] array = this.listUtils.stringListToStringArray(featVal);
                        if (array.length > 0 && !this.arrayAndListFSs.put(featVal, featVal)) {
                            this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
                        }
                        for (int j = 0; j < array.length; ++j) {
                            childElements.add(new XmlElementNameAndContents(new XmlElementName(null, featName, featName), array[j]));
                        }
                        attrValue = null;
                        break;
                    }
                    default: {
                        attrValue = this.getXmiId(featVal);
                    }
                }
                if (attrValue == null || featName == null) continue;
                this.addAttribute(attrs, featName, attrValue);
            }
            if (this.sharedData != null && (oed = this.sharedData.getOutOfTypeSystemFeatures(addr)) != null) {
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                childElements.addAll(oed.childElements);
            }
            return childElements;
        }

        private void addText(String text) throws SAXException {
            this.ch.characters(text.toCharArray(), 0, text.length());
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue) {
            int index = attrName.lastIndexOf(58) + 1;
            attrs.addAttribute("", attrName.substring(index), attrName, cdataType, attrValue);
        }

        private void startElement(XmlElementName name, Attributes attrs, int aNumChildren) throws SAXException {
            XmiCasSerializer.this.numChildren = aNumChildren;
            this.ch.startElement("", name.localName, name.qName, attrs);
        }

        private void endElement(XmlElementName name) throws SAXException {
            this.ch.endElement(name.nsUri, name.localName, name.qName);
        }

        private void stringArrayToElementList(String featName, int addr, List<? super XmlElementNameAndContents> resultList) throws SAXException {
            if (addr == 0) {
                return;
            }
            int size = this.cas.ll_getArraySize(addr);
            if (size > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to a String array.  Reference identity will not be preserved.");
            }
            int pos = this.cas.getArrayStartAddress(addr);
            for (int j = 0; j < size; ++j) {
                String s = this.cas.getStringForCode(this.cas.getHeapValue(pos));
                resultList.add(new XmlElementNameAndContents(new XmlElementName(null, featName, featName), s));
                ++pos;
            }
        }

        private String arrayToString(int addr, int arrayType) throws SAXException {
            String[] fsvalues;
            FeatureStructureImplC fs;
            if (addr == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            int size = this.cas.ll_getArraySize(addr);
            if (size > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to an array.  Reference identity will not be preserved in XMI.");
            }
            String elemStr = null;
            if (arrayType == 7) {
                int pos = this.cas.getArrayStartAddress(addr);
                List<XmiSerializationSharedData.XmiArrayElement> ootsArrayElementsList = this.sharedData == null ? null : this.sharedData.getOutOfTypeSystemArrayElements(addr);
                int ootsIndex = 0;
                for (int j = 0; j < size; ++j) {
                    int heapValue = this.cas.getHeapValue(pos++);
                    elemStr = null;
                    String xmiId = this.getXmiId(heapValue);
                    if (xmiId != null) {
                        elemStr = xmiId;
                    } else {
                        elemStr = "0";
                        if (ootsArrayElementsList != null) {
                            while (ootsIndex < ootsArrayElementsList.size()) {
                                XmiSerializationSharedData.XmiArrayElement arel = ootsArrayElementsList.get(ootsIndex++);
                                if (arel.index != j) continue;
                                elemStr = arel.xmiId;
                                break;
                            }
                        }
                    }
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(elemStr);
                }
                return buf.toString();
            }
            if (arrayType == 15) {
                ByteArrayFSImpl byteArrayFS = new ByteArrayFSImpl(addr, this.cas);
                int len = byteArrayFS.size();
                for (int i = 0; i < len; ++i) {
                    byte b = byteArrayFS.get(i);
                    if ((b & 0xF0) == 0) {
                        buf.append('0').append(Integer.toHexString(b).toUpperCase());
                        continue;
                    }
                    buf.append(Integer.toHexString(0xFF & b).toUpperCase());
                }
                return buf.toString();
            }
            switch (arrayType) {
                case 4: {
                    fs = new IntArrayFSImpl(addr, this.cas);
                    break;
                }
                case 5: {
                    fs = new FloatArrayFSImpl(addr, this.cas);
                    break;
                }
                case 14: {
                    fs = new BooleanArrayFSImpl(addr, this.cas);
                    break;
                }
                case 16: {
                    fs = new ShortArrayFSImpl(addr, this.cas);
                    break;
                }
                case 17: {
                    fs = new LongArrayFSImpl(addr, this.cas);
                    break;
                }
                case 18: {
                    fs = new DoubleArrayFSImpl(addr, this.cas);
                    break;
                }
                default: {
                    fs = null;
                }
            }
            if (arrayType == 6) {
                StringArrayFSImpl strFS = new StringArrayFSImpl(addr, this.cas);
                fsvalues = strFS.toArray();
            } else {
                fsvalues = fs.toStringArray();
            }
            for (int i = 0; i < fsvalues.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(fsvalues[i]);
            }
            return buf.toString();
        }

        private String listToString(int addr, int arrayType) throws SAXException {
            if (addr == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            String[] array = new String[]{};
            switch (arrayType) {
                case 101: {
                    array = this.listUtils.intListToStringArray(addr);
                    break;
                }
                case 102: {
                    array = this.listUtils.floatListToStringArray(addr);
                    break;
                }
                case 103: {
                    array = this.listUtils.stringListToStringArray(addr);
                    break;
                }
                case 104: {
                    array = this.listUtils.fsListToXmiIdStringArray(addr, this.sharedData);
                }
            }
            if (array.length > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
            }
            for (int j = 0; j < array.length; ++j) {
                buf.append(array[j]);
                if (j >= array.length - 1) continue;
                buf.append(' ');
            }
            return buf.toString();
        }

        private final int classifyType(int type) {
            if (this.listUtils.isIntListType(type)) {
                return 101;
            }
            if (this.listUtils.isFloatListType(type)) {
                return 102;
            }
            if (this.listUtils.isStringListType(type)) {
                return 103;
            }
            if (this.listUtils.isFsListType(type)) {
                return 104;
            }
            return this.cas.ll_getTypeClass(type);
        }

        private void initTypeAndNamespaceMappings() {
            this.nsUriToPrefixMap.put(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_NS_PREFIX);
            this.xmiTypeNames = new XmlElementName[this.cas.getTypeSystemImpl().getLargestTypeCode() + 1];
            if (this.sharedData != null) {
                for (XmiSerializationSharedData.OotsElementData oed : this.sharedData.getOutOfTypeSystemElements()) {
                    String nsUri = oed.elementName.nsUri;
                    String qname = oed.elementName.qName;
                    String localName = oed.elementName.localName;
                    String prefix = qname.substring(0, qname.indexOf(localName) - 1);
                    this.nsUriToPrefixMap.put(nsUri, prefix);
                    this.nsPrefixesUsed.add(prefix);
                }
            }
            Iterator<Type> it = this.cas.getTypeSystemImpl().getTypeIterator();
            while (it.hasNext()) {
                TypeImpl t = (TypeImpl)it.next();
                this.xmiTypeNames[t.getCode()] = this.uimaTypeName2XmiElementName(t.getName());
            }
        }

        private XmlElementName uimaTypeName2XmiElementName(String uimaTypeName) {
            String nsUri;
            String shortName;
            int lastDotIndex = uimaTypeName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                shortName = uimaTypeName;
                nsUri = XmiCasSerializer.DEFAULT_NAMESPACE_URI;
            } else {
                int i;
                shortName = uimaTypeName.substring(lastDotIndex + 1);
                char[] sb = new char[lastDotIndex + 14];
                System.arraycopy(URIPFX, 0, sb, 0, URIPFX.length);
                for (i = 0; i < lastDotIndex; ++i) {
                    char c = uimaTypeName.charAt(i);
                    sb[URIPFX.length + i] = c == '.' ? 47 : (int)c;
                }
                System.arraycopy(URISFX, 0, sb, URIPFX.length + i, URISFX.length);
                nsUri = this.getUniqueString(new String(sb));
            }
            shortName = this.getUniqueString(shortName);
            String prefix = this.nsUriToPrefixMap.get(nsUri);
            if (prefix == null) {
                if (lastDotIndex != -1) {
                    int secondLastDotIndex = uimaTypeName.lastIndexOf(46, lastDotIndex - 1);
                    prefix = uimaTypeName.substring(secondLastDotIndex + 1, lastDotIndex);
                } else {
                    prefix = "noNamespace";
                }
                if (this.nsPrefixesUsed.contains(prefix)) {
                    String basePrefix = prefix;
                    int num = 2;
                    while (this.nsPrefixesUsed.contains(basePrefix + num)) {
                        ++num;
                    }
                    prefix = basePrefix + num;
                }
                this.nsUriToPrefixMap.put(nsUri, prefix);
                this.nsPrefixesUsed.add(prefix);
            }
            return new XmlElementName(nsUri, shortName, this.getUniqueString(prefix + ':' + shortName));
        }

        private String getUniqueString(String s) {
            String u = this.uniqueStrings.get(s);
            if (null == u) {
                u = s;
                this.uniqueStrings.put(s, s);
            }
            return u;
        }

        private void serializeOutOfTypeSystemElements() throws SAXException {
            if (this.marker != null) {
                return;
            }
            if (this.sharedData == null) {
                return;
            }
            for (XmiSerializationSharedData.OotsElementData oed : this.sharedData.getOutOfTypeSystemElements()) {
                this.workAttrs.clear();
                this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, oed.xmiId);
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                this.startElement(oed.elementName, this.workAttrs, oed.childElements.size());
                for (XmlElementNameAndContents child : oed.childElements) {
                    this.workAttrs.clear();
                    for (XmlAttribute attr : child.attributes) {
                        this.addAttribute(this.workAttrs, attr.name, attr.value);
                    }
                    if (child.contents != null) {
                        this.startElement(child.name, this.workAttrs, 1);
                        this.addText(child.contents);
                    } else {
                        this.startElement(child.name, this.workAttrs, 0);
                    }
                    this.endElement(child.name);
                }
                this.endElement(oed.elementName);
            }
        }
    }
}

