/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.internal.util.JmxMBeanAgent;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.impl.CasPoolManagementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasManager_impl
implements CasManager {
    private ResourceManager mResourceManager;
    private List<ProcessingResourceMetaData> mMetaDataList = new ArrayList<ProcessingResourceMetaData>();
    private Map<String, CasPool> mRequestorToCasPoolMap = Collections.synchronizedMap(new HashMap());
    private Map<CAS, CasPool> mCasToCasPoolMap = Collections.synchronizedMap(new HashMap());
    private Map<CAS, UimaContext> mCasToUimaContextMap = Collections.synchronizedMap(new HashMap());
    private CasDefinition mCasDefinition = null;
    private TypeSystem mCurrentTypeSystem = null;
    private Object mMBeanServer;
    private String mMBeanNamePrefix;
    private List<CasPoolManagementImpl> casPoolMBeans = new ArrayList<CasPoolManagementImpl>();

    public CasManager_impl(ResourceManager aResourceManager) {
        this.mResourceManager = aResourceManager;
    }

    @Override
    public void addMetaData(ProcessingResourceMetaData aMetaData) {
        this.mMetaDataList.add(aMetaData);
        this.mCasDefinition = null;
        this.mCurrentTypeSystem = null;
    }

    @Override
    public CasDefinition getCasDefinition() throws ResourceInitializationException {
        if (this.mCasDefinition == null) {
            this.mCasDefinition = new CasDefinition(this.mMetaDataList, this.mResourceManager);
        }
        return this.mCasDefinition;
    }

    @Override
    public CAS getCas(String aRequestorContextName) {
        CasPool pool = this.mRequestorToCasPoolMap.get(aRequestorContextName);
        if (pool == null) {
            throw new UIMARuntimeException("requested_too_many_cas_instances", new Object[]{aRequestorContextName, "1", "0"});
        }
        return pool.getCas(0L);
    }

    @Override
    public void releaseCas(AbstractCas aCAS) {
        if (!(aCAS instanceof CASImpl) && !(aCAS instanceof JCas)) {
            throw new UIMARuntimeException("unsupported_cas_interface", new Object[]{aCAS.getClass()});
        }
        CASImpl baseCas = aCAS instanceof JCas ? ((JCas)aCAS).getCasImpl().getBaseCAS() : ((CASImpl)aCAS).getBaseCAS();
        CasPool pool = this.mCasToCasPoolMap.get(baseCas);
        if (pool == null) {
            throw new UIMARuntimeException("cas_released_to_wrong_cas_manager", new Object[0]);
        }
        UimaContextAdmin uc = (UimaContextAdmin)this.mCasToUimaContextMap.get(baseCas);
        if (uc != null) {
            uc.returnedCAS(aCAS);
        }
        pool.releaseCas((CAS)aCAS);
    }

    @Override
    public void defineCasPool(String aRequestorContextName, int aMinimumSize, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this.defineCasPool(null, aRequestorContextName, aMinimumSize, aPerformanceTuningSettings);
    }

    @Override
    public void defineCasPool(UimaContextAdmin aRequestorContext, int aMinimumSize, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this.defineCasPool(aRequestorContext, aRequestorContext.getUniqueName(), aMinimumSize, aPerformanceTuningSettings);
    }

    private synchronized void defineCasPool(UimaContext aRequestorContext, String aRequestorContextName, int aMinimumSize, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        int poolSize = this.getCasPoolSize(aRequestorContextName, aMinimumSize);
        if (poolSize > 0) {
            CasPool pool = this.mRequestorToCasPoolMap.get(aRequestorContextName);
            if (pool == null) {
                pool = new CasPool(poolSize, this, aPerformanceTuningSettings);
                this.populateCasToCasPoolAndUimaContextMaps(pool, aRequestorContext);
                this.mRequestorToCasPoolMap.put(aRequestorContextName, pool);
                this.registerCasPoolMBean(aRequestorContextName, pool);
            } else {
                throw new UIMARuntimeException("define_cas_pool_called_twice", new Object[]{aRequestorContextName});
            }
        }
    }

    @Override
    public CAS createNewCas(Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        CAS cas;
        if (this.mCurrentTypeSystem != null) {
            cas = CasCreationUtils.createCas(this.getCasDefinition(), aPerformanceTuningSettings, this.mCurrentTypeSystem);
        } else {
            cas = CasCreationUtils.createCas(this.getCasDefinition(), aPerformanceTuningSettings);
            this.mCurrentTypeSystem = cas.getTypeSystem();
        }
        return cas;
    }

    @Override
    public AbstractCas getCasInterface(CAS cas, Class<? extends AbstractCas> requiredInterface) {
        if (requiredInterface == CAS.class) {
            return cas;
        }
        if (requiredInterface == JCas.class) {
            try {
                return cas.getJCas();
            }
            catch (CASException e) {
                throw new UIMARuntimeException(e);
            }
        }
        if (requiredInterface.isInstance(cas)) {
            return cas;
        }
        throw new UIMARuntimeException("unsupported_cas_interface", new Object[]{requiredInterface});
    }

    public static AbstractCas getCasInterfaceStatic(CAS cas, Class<? extends AbstractCas> requiredInterface) {
        if (requiredInterface == CAS.class) {
            return cas;
        }
        if (requiredInterface == JCas.class) {
            try {
                return cas.getJCas();
            }
            catch (CASException e) {
                throw new UIMARuntimeException(e);
            }
        }
        if (requiredInterface.isInstance(cas)) {
            return cas;
        }
        throw new UIMARuntimeException("unsupported_cas_interface", new Object[]{requiredInterface});
    }

    @Override
    public void setJmxInfo(Object aMBeanServer, String aRootMBeanName) {
        this.mMBeanServer = aMBeanServer;
        this.mMBeanNamePrefix = aRootMBeanName.endsWith("\"") ? aRootMBeanName.substring(0, aRootMBeanName.length() - 1) + " CAS Pools\"," : aRootMBeanName + " CAS Pools,";
    }

    protected Map<CAS, CasPool> getCasToCasPoolMap() {
        return this.mCasToCasPoolMap;
    }

    protected void populateCasToCasPoolMap(CasPool aCasPool) {
        this.populateCasToCasPoolAndUimaContextMaps(aCasPool, null);
    }

    protected void populateCasToCasPoolAndUimaContextMaps(CasPool aCasPool, UimaContext aUimaContext) {
        int i;
        CAS[] casArray = new CAS[aCasPool.getSize()];
        for (i = 0; i < casArray.length; ++i) {
            casArray[i] = ((CASImpl)aCasPool.getCas()).getBaseCAS();
            this.mCasToCasPoolMap.put(casArray[i], aCasPool);
            if (aUimaContext == null) continue;
            this.mCasToUimaContextMap.put(casArray[i], aUimaContext);
        }
        for (i = 0; i < casArray.length; ++i) {
            aCasPool.releaseCas(casArray[i]);
        }
    }

    protected void registerCasPoolMBean(String aRequestorContextName, CasPool pool) {
        if (this.mMBeanNamePrefix != null) {
            String mbeanName = this.mMBeanNamePrefix + "casPoolContextName=" + aRequestorContextName;
            CasPoolManagementImpl mbean = new CasPoolManagementImpl(pool, mbeanName);
            JmxMBeanAgent.registerMBean(mbean, this.mMBeanServer);
            this.casPoolMBeans.add(mbean);
        }
    }

    protected int getCasPoolSize(String aRequestorContextName, int aMinimumSize) {
        return aMinimumSize;
    }

    protected void finalize() throws Throwable {
        for (CasPoolManagementImpl mbean : this.casPoolMBeans) {
            JmxMBeanAgent.unregisterMBean(mbean, this.mMBeanServer);
        }
        super.finalize();
    }
}

