/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.impl.ConfigurationManagerImplBase;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.util.Level;
import org.apache.uima.util.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager_impl
extends ConfigurationManagerImplBase {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private Map<String, Object> mSharedParamMap = Collections.synchronizedMap(new HashMap());

    @Override
    protected void declareParameters(String aGroupName, ConfigurationParameter[] aParams, ConfigurationParameterSettings aSettings, String aContextName, Settings aExternalOverrides) throws ResourceConfigurationException {
        super.declareParameters(aGroupName, aParams, aSettings, aContextName, aExternalOverrides);
        if (aParams != null) {
            for (int i = 0; i < aParams.length; ++i) {
                String propValue;
                String qname = this.makeQualifiedName(aContextName, aParams[i].getName(), aGroupName);
                String from = "";
                Object paramValue = aSettings.getParameterValue(aGroupName, aParams[i].getName());
                String extName = aParams[i].getExternalOverrideName();
                if (extName != null && aExternalOverrides != null && (propValue = aExternalOverrides.lookUp(extName)) != null) {
                    Object result = this.createParam(propValue, aParams[i].getType(), aParams[i].isMultiValued());
                    if (result == null) {
                        throw new NumberFormatException("Array mismatch assigning value of " + extName + " ('" + propValue + "') to " + aParams[i].getName());
                    }
                    paramValue = result;
                    this.mLinkMap.remove(qname);
                    from = "(overridden from " + extName + ")";
                }
                this.mSharedParamMap.put(qname, paramValue);
                if (!UIMAFramework.getLogger(this.getClass()).isLoggable(Level.CONFIG)) continue;
                Object realValue = paramValue;
                if (from.length() == 0) {
                    String linkedTo = qname;
                    while (this.getLink(linkedTo) != null) {
                        linkedTo = this.getLink(linkedTo);
                    }
                    if (linkedTo != qname && this.lookup(linkedTo) != null) {
                        realValue = this.lookup(linkedTo);
                        from = "(overridden from " + linkedTo + ")";
                    }
                }
                if (realValue == null) continue;
                if (aParams[i].isMultiValued()) {
                    try {
                        Object[] array = (Object[])realValue;
                        realValue = Arrays.toString(array);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "declareParameters", LOG_RESOURCE_BUNDLE, "UIMA_parameter_set__CONFIG", new Object[]{aParams[i].getName(), aContextName, realValue, from});
            }
        }
    }

    @Override
    protected Object lookupSharedParamNoLinks(String aCompleteName) {
        return this.mSharedParamMap.get(aCompleteName);
    }

    private Object createParam(String value, String paramType, boolean isArray) throws NumberFormatException {
        boolean arrayValue;
        boolean bl = arrayValue = value.length() > 0 && value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']';
        if (arrayValue ^ isArray) {
            return null;
        }
        try {
            if (paramType.equals("Boolean")) {
                return this.createParamForClass(value, isArray, Boolean.class);
            }
            if (paramType.equals("Integer")) {
                return this.createParamForClass(value, isArray, Integer.class);
            }
            if (paramType.equals("Float")) {
                return this.createParamForClass(value, isArray, Float.class);
            }
            return this.createParamForClass(value, isArray, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NumberFormatException("Failed to convert '" + value + "' to " + paramType);
        }
    }

    private <T> Object createParamForClass(String value, boolean isArray, Class<T> clas) throws Exception {
        Method valOf = null;
        try {
            valOf = clas.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            valOf = StringX.class.getMethod("valueOf", String.class);
        }
        if (isArray) {
            int i;
            if ((value = value.substring(1, value.length() - 1)).length() == 0) {
                return (Object[])Array.newInstance(clas, 0);
            }
            String[] tokens = value.split(",");
            int nTokens = tokens.length;
            for (i = 0; i < tokens.length - 1; ++i) {
                if (!this.endsWithEscape(tokens[i])) continue;
                tokens[i + 1] = tokens[i] + "," + tokens[i + 1];
                tokens[i] = null;
                --nTokens;
            }
            if (this.endsWithEscape(tokens[i])) {
                int n = i;
                tokens[n] = tokens[n] + ",";
            }
            Object[] result = (Object[])Array.newInstance(clas, nTokens);
            i = 0;
            for (String token : tokens) {
                if (token == null) continue;
                result[i++] = valOf.invoke(null, this.escape(token.trim()));
            }
            return result;
        }
        return valOf.invoke(null, this.escape(value));
    }

    private String escape(String token) {
        int next = token.indexOf(92);
        if (next < 0) {
            return token;
        }
        StringBuilder result = new StringBuilder(token.length());
        int last = 0;
        while (next >= 0) {
            result.append(token.substring(last, next));
            last = next + 1;
            next = token.indexOf(92, last + 1);
        }
        result.append(token.substring(last));
        return result.toString();
    }

    private boolean endsWithEscape(String line) {
        int i;
        for (i = line.length(); i > 0 && line.charAt(i - 1) == '\\'; --i) {
        }
        return (line.length() - i) % 2 != 0;
    }

    static class StringX {
        StringX() {
        }

        public static String valueOf(String s) {
            return s;
        }
    }
}

