/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger_impl
implements Logger {
    private static final PrintStream defaultOut = System.out;
    private PrintStream mOut;
    private Level configLevel = Level.INFO;
    private static final Logger_impl defaultLogger = new Logger_impl();
    private ResourceManager mResourceManager = null;

    private Logger_impl() {
        this.mOut = defaultOut;
    }

    public static synchronized Logger getInstance(Class<?> component) {
        return new Logger_impl();
    }

    public static synchronized Logger getInstance() {
        return defaultLogger;
    }

    @Override
    @Deprecated
    public void log(String aMessage) {
        if (this.isLoggable(Level.INFO) && this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + Level.INFO.toString() + ": ");
            this.mOut.println(aMessage);
        }
    }

    @Override
    @Deprecated
    public void log(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        if (this.isLoggable(Level.INFO)) {
            this.log(I18nUtil.localizeMessage(aResourceBundleName, aMessageKey, aArguments, this.getExtensionClassLoader()));
        }
    }

    @Override
    @Deprecated
    public void logException(Exception aException) {
        if (this.isLoggable(Level.INFO) && this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + Level.INFO.toString() + ": ");
            aException.printStackTrace(this.mOut);
        }
    }

    @Override
    @Deprecated
    public void setOutputStream(OutputStream out) {
        this.mOut = out == null || out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    @Override
    @Deprecated
    public void setOutputStream(PrintStream out) {
        this.mOut = out;
    }

    private void logException(Level level, Throwable thrown) {
        this.mOut.print(new Date());
        this.mOut.print(": " + level.toString() + ": ");
        thrown.printStackTrace(this.mOut);
    }

    private void logMessage(Level level, String aMessage) {
        if (this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + level.toString() + ": ");
            this.mOut.println(aMessage);
        }
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.configLevel.isGreaterOrEqual(level);
    }

    @Override
    public void log(Level level, String aMessage) {
        if (this.isLoggable(level)) {
            this.logMessage(level, aMessage);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object param1) {
        if (this.isLoggable(level)) {
            String result = MessageFormat.format(aMessage, param1);
            this.logMessage(level, result);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object[] params) {
        if (this.isLoggable(level)) {
            String result = MessageFormat.format(aMessage, params);
            this.logMessage(level, result);
        }
    }

    @Override
    public void log(Level level, String aMessage, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.logMessage(level, aMessage);
            this.logException(level, thrown);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object param1) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(bundleName, msgKey, new Object[]{param1}, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object[] params) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(bundleName, msgKey, params, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()));
            this.logException(level, thrown);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void log(String wrapperFQCN, Level level, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.logMessage(level, message);
            if (thrown != null) {
                this.logException(level, thrown);
            }
        }
    }

    @Override
    public void setLevel(Level level) {
        this.configLevel = level;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.mResourceManager = resourceManager;
    }

    private ClassLoader getExtensionClassLoader() {
        if (this.mResourceManager == null) {
            return null;
        }
        return this.mResourceManager.getExtensionClassLoader();
    }
}

