/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.ngram;

import java.util.Map;
import org.exist.dom.QName;
import org.exist.util.DatabaseConfigurationException;

public class NGramIndexConfig {
    private QName qname;

    public NGramIndexConfig(Map<String, String> namespaces, String name) throws DatabaseConfigurationException {
        boolean isAttribute = false;
        if (name.startsWith("@")) {
            isAttribute = true;
            name = name.substring(1);
        }
        try {
            String prefix = QName.extractPrefix((String)name);
            String localName = QName.extractLocalName((String)name);
            String namespaceURI = "";
            if (prefix != null && (namespaceURI = namespaces.get(prefix)) == null) {
                throw new DatabaseConfigurationException("NGram index conifg: no namespace defined for prefix: " + prefix + " in index definition");
            }
            this.qname = isAttribute ? new QName(localName, namespaceURI, prefix, 1) : new QName(localName, namespaceURI, prefix);
        }
        catch (QName.IllegalQNameException e) {
            throw new DatabaseConfigurationException("NGram index configuration: " + e.getMessage(), (Throwable)e);
        }
    }

    public QName getQName() {
        return this.qname;
    }
}

