/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.query;

import org.exist.xquery.modules.ngram.query.MergeableExpression;
import org.exist.xquery.modules.ngram.query.WildcardedExpression;

public class Wildcard
implements WildcardedExpression,
MergeableExpression {
    final int minimumLength;
    final int maximumLength;

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public Wildcard(int minimumLength, int maximumLength) {
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
    }

    public String toString() {
        return "Wildcard(" + this.minimumLength + ", " + this.maximumLength + ")";
    }

    @Override
    public WildcardedExpression mergeWith(WildcardedExpression otherExpression) {
        Wildcard other = (Wildcard)otherExpression;
        int newMaximumLength = this.maximumLength == Integer.MAX_VALUE || other.maximumLength == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maximumLength + other.maximumLength;
        return new Wildcard(this.minimumLength + other.minimumLength, newMaximumLength);
    }

    @Override
    public boolean mergeableWith(WildcardedExpression otherExpression) {
        return otherExpression instanceof Wildcard;
    }
}

