/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.EmptyNodeSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.ngram.query.EndAnchor;
import org.exist.xquery.modules.ngram.query.EvaluatableExpression;
import org.exist.xquery.modules.ngram.query.MergeableExpression;
import org.exist.xquery.modules.ngram.query.StartAnchor;
import org.exist.xquery.modules.ngram.query.Wildcard;
import org.exist.xquery.modules.ngram.query.WildcardedExpression;
import org.exist.xquery.modules.ngram.query.WildcardedExpressionTriple;
import org.exist.xquery.modules.ngram.utils.NodeProxies;
import org.exist.xquery.modules.ngram.utils.NodeSets;

public class WildcardedExpressionSequence
implements EvaluatableExpression {
    private final List<WildcardedExpression> expressions;
    private static Logger LOG = LogManager.getLogger(WildcardedExpressionSequence.class);

    public WildcardedExpressionSequence(List<WildcardedExpression> expressions) {
        this.expressions = new ArrayList<WildcardedExpression>(expressions.size());
        WildcardedExpression currentExpression = expressions.remove(0);
        for (WildcardedExpression expression : expressions) {
            if (currentExpression instanceof MergeableExpression && ((MergeableExpression)((Object)currentExpression)).mergeableWith(expression)) {
                currentExpression = ((MergeableExpression)((Object)currentExpression)).mergeWith(expression);
                continue;
            }
            this.expressions.add(currentExpression);
            currentExpression = expression;
        }
        this.expressions.add(currentExpression);
    }

    @Override
    public NodeSet eval(NGramIndexWorker index, DocumentSet docs, List<QName> qnames, NodeSet nodeSet, int axis, int expressionId) throws XPathException {
        boolean startAnchorPresent = false;
        if (!this.expressions.isEmpty() && this.expressions.get(0) instanceof StartAnchor) {
            startAnchorPresent = true;
            this.expressions.remove(0);
        }
        Wildcard leadingWildcard = null;
        if (!this.expressions.isEmpty() && this.expressions.get(0) instanceof Wildcard) {
            leadingWildcard = (Wildcard)this.expressions.remove(0);
        }
        boolean endAnchorPresent = false;
        if (!this.expressions.isEmpty() && this.expressions.get(this.expressions.size() - 1) instanceof EndAnchor) {
            endAnchorPresent = true;
            this.expressions.remove(this.expressions.size() - 1);
        }
        Wildcard trailingWildcard = null;
        if (!this.expressions.isEmpty() && this.expressions.get(this.expressions.size() - 1) instanceof Wildcard) {
            trailingWildcard = (Wildcard)this.expressions.remove(this.expressions.size() - 1);
        }
        while (this.expressions.size() >= 3) {
            this.formEvaluatableTriples(expressionId);
        }
        if (this.expressions.isEmpty()) {
            return new EmptyNodeSet();
        }
        if (this.expressions.size() != 1 || !(this.expressions.get(0) instanceof EvaluatableExpression)) {
            LOG.error("Expression " + this.toString() + " could not be evaluated");
            throw new XPathException("Could not evaluate wildcarded query.");
        }
        LOG.trace("Evaluating expression " + this.toString());
        NodeSet result = ((EvaluatableExpression)this.expressions.get(0)).eval(index, docs, qnames, nodeSet, axis, expressionId);
        if (leadingWildcard != null) {
            result = this.expandMatchesBackward(leadingWildcard, result, expressionId);
        }
        if (startAnchorPresent) {
            result = NodeSets.getNodesMatchingAtStart(result, expressionId);
        }
        if (trailingWildcard != null) {
            result = this.expandMatchesForward(trailingWildcard, result, expressionId);
        }
        if (endAnchorPresent) {
            result = NodeSets.getNodesMatchingAtEnd(result, expressionId);
        }
        return result;
    }

    private NodeSet expandMatchesForward(Wildcard trailingWildcard, NodeSet nodes, int expressionId) throws XPathException {
        return NodeSets.transformNodes(nodes, proxy -> NodeProxies.transformOwnMatches(proxy, match -> match.expandForward(trailingWildcard.minimumLength, trailingWildcard.maximumLength, proxy.getNodeValue().length()), expressionId));
    }

    private NodeSet expandMatchesBackward(Wildcard leadingWildcard, NodeSet nodes, int expressionId) throws XPathException {
        return NodeSets.transformNodes(nodes, proxy -> NodeProxies.transformOwnMatches(proxy, match -> match.expandBackward(leadingWildcard.minimumLength, leadingWildcard.maximumLength), expressionId));
    }

    private void formEvaluatableTriples(int expressionId) {
        WildcardedExpression first = this.expressions.get(0);
        WildcardedExpression second = this.expressions.get(1);
        WildcardedExpression third = this.expressions.get(2);
        if (!(first instanceof EvaluatableExpression && second instanceof Wildcard && third instanceof EvaluatableExpression)) {
            throw new IllegalArgumentException("Could not form evaluatable triples at the beginning of " + this.toString());
        }
        WildcardedExpressionTriple triple = new WildcardedExpressionTriple((EvaluatableExpression)first, (Wildcard)second, (EvaluatableExpression)third);
        this.expressions.subList(0, 3).clear();
        this.expressions.add(0, triple);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WildcardedExpressionSequence(");
        for (WildcardedExpression expression : this.expressions) {
            builder.append(expression.toString());
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

