/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.query;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.ngram.query.EvaluatableExpression;
import org.exist.xquery.modules.ngram.query.Wildcard;
import org.exist.xquery.modules.ngram.utils.NodeProxies;
import org.exist.xquery.modules.ngram.utils.NodeSets;

public class WildcardedExpressionTriple
implements EvaluatableExpression {
    private final EvaluatableExpression head;
    private final Wildcard wildcard;
    private final EvaluatableExpression tail;
    protected static Logger LOG = LogManager.getLogger(WildcardedExpressionTriple.class);

    public WildcardedExpressionTriple(EvaluatableExpression head, Wildcard wildcard, EvaluatableExpression tail) {
        this.head = head;
        this.wildcard = wildcard;
        this.tail = tail;
    }

    @Override
    public NodeSet eval(NGramIndexWorker index, DocumentSet docs, List<QName> qnames, NodeSet nodeSet, int axis, int expressionId) throws XPathException {
        NodeSet headNodes = this.head.eval(index, docs, qnames, nodeSet, axis, expressionId);
        if (headNodes.isEmpty()) {
            return headNodes;
        }
        NodeSet tailNodes = this.tail.eval(index, docs, qnames, nodeSet, axis, expressionId);
        if (tailNodes.isEmpty()) {
            return tailNodes;
        }
        NodeSet result = NodeSets.transformNodes(headNodes, headNode -> Optional.ofNullable(tailNodes.get(headNode)).map(tailNode -> this.getMatchingNode((NodeProxy)headNode, (NodeProxy)tailNode, expressionId)).orElse(null));
        return result;
    }

    private NodeProxy getMatchingNode(NodeProxy headNode, NodeProxy tailNode, int expressionId) {
        NodeProxy result = null;
        Match match = null;
        boolean found = false;
        for (Match headMatch = headNode.getMatches(); headMatch != null && !found; headMatch = headMatch.getNextMatch()) {
            for (Match tailMatch = tailNode.getMatches(); tailMatch != null && !found; tailMatch = tailMatch.getNextMatch()) {
                match = headMatch.followedBy(tailMatch, this.wildcard.getMinimumLength(), this.wildcard.getMaximumLength());
                found = match != null;
            }
        }
        if (found) {
            NodeProxies.filterMatches(tailNode, a -> a.getContextId() != expressionId);
            tailNode.addMatch(match);
            result = tailNode;
        }
        return result;
    }

    public String toString() {
        return "WildcardedExpressionTriple(" + this.head + ", " + this.wildcard + ", " + this.tail + ")";
    }
}

