/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.utils;

import java.util.function.Function;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.ngram.utils.NodeProxies;

public final class NodeSets {
    private NodeSets() {
    }

    public static NodeSet transformNodes(NodeSet nodes, Function<NodeProxy, NodeProxy> transform) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeProxy node = transform.apply((NodeProxy)iterator.next());
            if (node == null) continue;
            result.add(node);
        }
        result.iterate();
        return result;
    }

    public static NodeSet getNodesMatchingAtStart(NodeSet nodes, int expressionId) throws XPathException {
        return NodeSets.transformNodes(nodes, proxy -> NodeProxies.transformOwnMatches(proxy, match -> match.filterOffsetsStartingAt(0), expressionId));
    }

    public static NodeSet getNodesMatchingAtEnd(NodeSet nodes, int expressionId) throws XPathException {
        return NodeSets.transformNodes(nodes, proxy -> NodeProxies.transformOwnMatches(proxy, match -> match.filterOffsetsEndingAt(proxy.getNodeValue().length()), expressionId));
    }
}

