/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.model.dom;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Attribute;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.model.dom.DomAttribute;
import org.expath.tools.model.dom.DomSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomElement
implements Element {
    private final org.w3c.dom.Element myElem;

    public static Element parseString(String xml) throws ToolsException {
        try {
            StringReader reader = new StringReader(xml);
            InputSource source = new InputSource(reader);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            org.w3c.dom.Element root = doc.getDocumentElement();
            return new DomElement(root);
        }
        catch (ParserConfigurationException ex) {
            throw new ToolsException("Error instantiating the DOM parser", ex);
        }
        catch (IOException | SAXException ex) {
            throw new ToolsException("Error parsing the XML string", ex);
        }
    }

    public DomElement(org.w3c.dom.Element elem) {
        this.myElem = elem;
    }

    @Override
    public String getLocalName() {
        return this.myElem.getLocalName();
    }

    @Override
    public String getNamespaceUri() {
        String ns = this.myElem.getNamespaceURI();
        return ns == null ? "" : ns;
    }

    @Override
    public String getDisplayName() {
        return this.getLocalName();
    }

    @Override
    public String getAttribute(String local_name) {
        return this.myElem.getAttribute(local_name);
    }

    @Override
    public Iterable<Attribute> attributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        NamedNodeMap map = this.myElem.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr a = (Attr)map.item(i);
            attrs.add(new DomAttribute(a));
        }
        return attrs;
    }

    @Override
    public boolean hasNoNsChild() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterable<Element> children() {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList list = this.myElem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            org.w3c.dom.Element e = (org.w3c.dom.Element)n;
            children.add(new DomElement(e));
        }
        return children;
    }

    @Override
    public Iterable<Element> children(String ns) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList list = this.myElem.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || !ns.equals(n.getNamespaceURI())) continue;
            org.w3c.dom.Element e = (org.w3c.dom.Element)n;
            children.add(new DomElement(e));
        }
        return children;
    }

    @Override
    public void noOtherNCNameAttribute(String[] names, String[] forbidden_ns) throws ToolsException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Sequence getContent() {
        NodeList children = this.myElem.getChildNodes();
        return new DomSequence(children);
    }

    @Override
    public QName parseQName(String value) throws ToolsException {
        int colon = value.indexOf(58);
        if (colon < 0) {
            String ns = this.myElem.lookupNamespaceURI(null);
            if (ns == null) {
                return new QName(value);
            }
            return new QName(ns, value);
        }
        String prefix = value.substring(0, colon);
        String ns = this.myElem.lookupNamespaceURI(prefix);
        if (ns == null) {
            throw new ToolsException("No namespace in scope for prefix of QName: " + value);
        }
        String local = value.substring(colon + 1);
        return new QName(ns, local);
    }
}

