/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;

public final class BinaryTokenStream
extends TokenStream {
    private final ByteTermAttribute bytesAtt = (ByteTermAttribute)this.addAttribute(ByteTermAttribute.class);
    private boolean available = true;

    public BinaryTokenStream(BytesRef bytes) {
        this.bytesAtt.setBytesRef(bytes);
    }

    public boolean incrementToken() {
        if (this.available) {
            this.available = false;
            return true;
        }
        return false;
    }

    public void reset() {
        this.available = true;
    }

    public static class ByteTermAttributeImpl
    extends AttributeImpl
    implements ByteTermAttribute,
    TermToBytesRefAttribute {
        private BytesRef bytes;

        public void fillBytesRef() {
        }

        public BytesRef getBytesRef() {
            return this.bytes;
        }

        @Override
        public void setBytesRef(BytesRef bytes) {
            this.bytes = bytes;
        }

        public void clear() {
        }

        public void copyTo(AttributeImpl target) {
            ByteTermAttributeImpl other = (ByteTermAttributeImpl)target;
            other.bytes = this.bytes;
        }
    }

    public static interface ByteTermAttribute
    extends TermToBytesRefAttribute {
        public void setBytesRef(BytesRef var1);
    }
}

