/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.QueryParserWrapper;
import org.exist.xquery.XPathException;

public class ClassicQueryParserWrapper
extends QueryParserWrapper {
    private static final Logger LOG = LogManager.getLogger(ClassicQueryParserWrapper.class);
    private QueryParserBase parser = null;

    public ClassicQueryParserWrapper(String className, String field, Analyzer analyzer) {
        super(field, analyzer);
        try {
            Class<?> clazz = Class.forName(className);
            if (QueryParserBase.class.isAssignableFrom(clazz)) {
                Class[] cParamClasses = new Class[]{Version.class, String.class, Analyzer.class};
                Constructor<?> cstr = clazz.getDeclaredConstructor(cParamClasses);
                this.parser = (QueryParserBase)cstr.newInstance(LuceneIndex.LUCENE_VERSION_IN_USE, field, analyzer);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            LOG.warn("Failed to instantiate lucene query parser class: " + className, (Throwable)e);
        }
        catch (InstantiationException | NoSuchMethodException e) {
            LOG.warn("Failed to instantiate lucene query parser class: " + className + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public ClassicQueryParserWrapper(String field, Analyzer analyzer) {
        super(field, analyzer);
        this.parser = new QueryParser(LuceneIndex.LUCENE_VERSION_IN_USE, field, analyzer);
    }

    @Override
    public Query parse(String query) throws XPathException {
        try {
            return this.parser.parse(query);
        }
        catch (ParseException e) {
            throw new XPathException("Syntax error in Lucene query string: " + e.getMessage());
        }
    }

    @Override
    public CommonQueryParserConfiguration getConfiguration() {
        return this.parser;
    }
}

