/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.exist.dom.QName;
import org.exist.indexing.lucene.AnalyzerConfig;
import org.exist.indexing.lucene.ClassicQueryParserWrapper;
import org.exist.indexing.lucene.FieldType;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexConfig;
import org.exist.indexing.lucene.QueryParserWrapper;
import org.exist.indexing.lucene.analyzers.NoDiacriticsStandardAnalyzer;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LuceneConfig {
    private static final Logger LOG = LogManager.getLogger(LuceneConfig.class);
    private static final String CONFIG_ROOT = "lucene";
    private static final String INDEX_ELEMENT = "text";
    private static final String ANALYZER_ELEMENT = "analyzer";
    private static final String PARSER_ELEMENT = "parser";
    protected static final String FIELD_TYPE_ELEMENT = "fieldType";
    private static final String INLINE_ELEMENT = "inline";
    private static final String IGNORE_ELEMENT = "ignore";
    private static final String BOOST_ATTRIB = "boost";
    private static final String DIACRITICS = "diacritics";
    private Map<QName, LuceneIndexConfig> paths = new TreeMap<QName, LuceneIndexConfig>();
    private List<LuceneIndexConfig> wildcardPaths = new ArrayList<LuceneIndexConfig>();
    private Map<String, LuceneIndexConfig> namedIndexes = new TreeMap<String, LuceneIndexConfig>();
    private Map<String, FieldType> fieldTypes = new HashMap<String, FieldType>();
    private Set<QName> inlineNodes = null;
    private Set<QName> ignoreNodes = null;
    private final PathIterator iterator = new PathIterator();
    private float boost = -1.0f;
    private AnalyzerConfig analyzers = new AnalyzerConfig();
    private String queryParser = null;

    public LuceneConfig(NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        this.parseConfig(configNodes, namespaces);
    }

    public LuceneConfig(LuceneConfig other) {
        this.paths = other.paths;
        this.wildcardPaths = other.wildcardPaths;
        this.namedIndexes = other.namedIndexes;
        this.fieldTypes = other.fieldTypes;
        this.inlineNodes = other.inlineNodes;
        this.ignoreNodes = other.ignoreNodes;
        this.boost = other.boost;
        this.analyzers = other.analyzers;
    }

    public boolean matches(NodePath path) {
        for (LuceneIndexConfig idxConf = this.paths.get(path.getLastComponent()); idxConf != null; idxConf = idxConf.getNext()) {
            if (!idxConf.match(path)) continue;
            return true;
        }
        for (LuceneIndexConfig config : this.wildcardPaths) {
            if (!config.match(path)) continue;
            return true;
        }
        return false;
    }

    public Iterator<LuceneIndexConfig> getConfig(NodePath path) {
        this.iterator.reset(path);
        return this.iterator;
    }

    protected LuceneIndexConfig getWildcardConfig(NodePath path) {
        for (LuceneIndexConfig wildcardPath : this.wildcardPaths) {
            LuceneIndexConfig config = wildcardPath;
            if (!config.match(path)) continue;
            return config;
        }
        return null;
    }

    public Analyzer getAnalyzer(QName qname) {
        String id;
        LuceneIndexConfig idxConf;
        for (idxConf = this.paths.get(qname); idxConf != null && (idxConf.isNamed() || !idxConf.getNodePath().match(qname)); idxConf = idxConf.getNext()) {
        }
        if (idxConf != null && (id = idxConf.getAnalyzerId()) != null) {
            return this.analyzers.getAnalyzerById(idxConf.getAnalyzerId());
        }
        return this.analyzers.getDefaultAnalyzer();
    }

    public Analyzer getAnalyzer(NodePath nodePath) {
        String id;
        LuceneIndexConfig idxConf;
        if (nodePath.length() == 0) {
            throw new RuntimeException();
        }
        for (idxConf = this.paths.get(nodePath.getLastComponent()); idxConf != null && (idxConf.isNamed() || !idxConf.match(nodePath)); idxConf = idxConf.getNext()) {
        }
        if (idxConf == null) {
            for (LuceneIndexConfig config : this.wildcardPaths) {
                if (!config.match(nodePath)) continue;
                return config.getAnalyzer();
            }
        }
        if (idxConf != null && (id = idxConf.getAnalyzerId()) != null) {
            return this.analyzers.getAnalyzerById(idxConf.getAnalyzerId());
        }
        return this.analyzers.getDefaultAnalyzer();
    }

    public Analyzer getAnalyzer(String field) {
        String id;
        LuceneIndexConfig config = this.namedIndexes.get(field);
        if (config != null && (id = config.getAnalyzerId()) != null) {
            return this.analyzers.getAnalyzerById(config.getAnalyzerId());
        }
        return this.analyzers.getDefaultAnalyzer();
    }

    public Analyzer getAnalyzerById(String id) {
        return this.analyzers.getAnalyzerById(id);
    }

    public QueryParserWrapper getQueryParser(String field, Analyzer analyzer) {
        QueryParserWrapper parser = null;
        if (this.queryParser != null) {
            try {
                Class<?> clazz = Class.forName(this.queryParser);
                parser = QueryParserBase.class.isAssignableFrom(clazz) ? new ClassicQueryParserWrapper(this.queryParser, field, analyzer) : QueryParserWrapper.create(this.queryParser, field, analyzer);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to instantiate lucene query parser class: " + this.queryParser, (Throwable)e);
            }
        }
        if (parser == null) {
            parser = new ClassicQueryParserWrapper(field, analyzer);
        }
        return parser;
    }

    public boolean isInlineNode(QName qname) {
        return this.inlineNodes != null && this.inlineNodes.contains(qname);
    }

    public boolean isIgnoredNode(QName qname) {
        return this.ignoreNodes != null && this.ignoreNodes.contains(qname);
    }

    public float getBoost() {
        return this.boost;
    }

    public FieldType getFieldType(String name) {
        return this.fieldTypes.get(name);
    }

    protected void parseConfig(NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Node node = configNodes.item(i);
            if (node.getNodeType() != 1) continue;
            try {
                String localName = node.getLocalName();
                if (null == localName) continue;
                switch (localName) {
                    case "lucene": {
                        String value;
                        Element elem = (Element)node;
                        if (elem.hasAttribute(BOOST_ATTRIB)) {
                            value = elem.getAttribute(BOOST_ATTRIB);
                            try {
                                this.boost = Float.parseFloat(value);
                            }
                            catch (NumberFormatException e) {
                                throw new DatabaseConfigurationException("Invalid value for 'boost' attribute in lucene index config: float expected, got " + value);
                            }
                        }
                        if (elem.hasAttribute(DIACRITICS) && (value = elem.getAttribute(DIACRITICS)).equalsIgnoreCase("no")) {
                            this.analyzers.setDefaultAnalyzer((Analyzer)new NoDiacriticsStandardAnalyzer(LuceneIndex.LUCENE_VERSION_IN_USE));
                        }
                        this.parseConfig(node.getChildNodes(), namespaces);
                        break;
                    }
                    case "analyzer": {
                        this.analyzers.addAnalyzer((Element)node);
                        break;
                    }
                    case "parser": {
                        this.queryParser = ((Element)node).getAttribute("class");
                        break;
                    }
                    case "fieldType": {
                        FieldType type = new FieldType((Element)node, this.analyzers);
                        this.fieldTypes.put(type.getId(), type);
                        break;
                    }
                    case "text": {
                        Element elem = (Element)node;
                        LuceneIndexConfig config = new LuceneIndexConfig(elem, namespaces, this.analyzers, this.fieldTypes);
                        if (config.getName() != null) {
                            this.namedIndexes.put(config.getName(), config);
                        }
                        if (config.getNodePath().hasWildcard()) {
                            this.wildcardPaths.add(config);
                            break;
                        }
                        LuceneIndexConfig idxConf = this.paths.get(config.getNodePath().getLastComponent());
                        if (idxConf == null) {
                            this.paths.put(config.getNodePath().getLastComponent(), config);
                            break;
                        }
                        idxConf.add(config);
                        break;
                    }
                    case "inline": {
                        Element elem = (Element)node;
                        QName qname = LuceneIndexConfig.parseQName(elem, namespaces);
                        if (this.inlineNodes == null) {
                            this.inlineNodes = new TreeSet<QName>();
                        }
                        this.inlineNodes.add(qname);
                        break;
                    }
                    case "ignore": {
                        Element elem = (Element)node;
                        QName qname = LuceneIndexConfig.parseQName(elem, namespaces);
                        if (this.ignoreNodes == null) {
                            this.ignoreNodes = new TreeSet<QName>();
                        }
                        this.ignoreNodes.add(qname);
                        break;
                    }
                }
                continue;
            }
            catch (DatabaseConfigurationException e) {
                LOG.warn("Invalid lucene configuration element: " + e.getMessage());
            }
        }
    }

    private class PathIterator
    implements Iterator<LuceneIndexConfig> {
        private LuceneIndexConfig nextConfig;
        private NodePath path;
        private boolean atLast = false;

        private PathIterator() {
        }

        protected void reset(NodePath path) {
            this.atLast = false;
            this.path = path;
            this.nextConfig = (LuceneIndexConfig)LuceneConfig.this.paths.get(path.getLastComponent());
            if (this.nextConfig == null) {
                this.nextConfig = LuceneConfig.this.getWildcardConfig(path);
                this.atLast = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextConfig != null;
        }

        @Override
        public LuceneIndexConfig next() {
            if (this.nextConfig == null) {
                return null;
            }
            LuceneIndexConfig currentConfig = this.nextConfig;
            this.nextConfig = this.nextConfig.getNext();
            if (this.nextConfig == null && !this.atLast) {
                this.nextConfig = LuceneConfig.this.getWildcardConfig(this.path);
                this.atLast = true;
            }
            return currentConfig;
        }

        @Override
        public void remove() {
        }
    }
}

