/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import com.evolvedbinary.j8fu.function.Function2E;
import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.indexing.lucene.AnalyzerConfig;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.xquery.XPathException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LuceneIndex
extends AbstractIndex
implements RawBackupSupport {
    public static final Version LUCENE_VERSION_IN_USE = Version.LUCENE_4_10_4;
    private static final Logger LOG = LogManager.getLogger(LuceneIndexWorker.class);
    public static final String ID = LuceneIndex.class.getName();
    private static final String DIR_NAME = "lucene";
    protected Directory directory;
    protected Analyzer defaultAnalyzer;
    protected double bufferSize = 16.0;
    protected IndexWriter cachedWriter = null;
    protected SearcherManager searcherManager = null;
    protected ReaderManager readerManager = null;
    protected boolean needsCommit = false;

    public String getDirName() {
        return DIR_NAME;
    }

    public void configure(BrokerPool pool, Path dataDir, Element config) throws DatabaseConfigurationException {
        NodeList nl;
        String bufferSizeParam;
        super.configure(pool, dataDir, config);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring Lucene index");
        }
        if ((bufferSizeParam = config.getAttribute("buffer")) != null) {
            try {
                this.bufferSize = Double.parseDouble(bufferSizeParam);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid buffer size setting for lucene index: " + bufferSizeParam, (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using buffer size: " + this.bufferSize);
        }
        if ((nl = config.getElementsByTagName("analyzer")).getLength() > 0) {
            Element node = (Element)nl.item(0);
            this.defaultAnalyzer = AnalyzerConfig.configureAnalyzer(node);
        }
        if (this.defaultAnalyzer == null) {
            this.defaultAnalyzer = new StandardAnalyzer(LUCENE_VERSION_IN_USE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using default analyzer: " + this.defaultAnalyzer.getClass().getName());
        }
    }

    public void open() throws DatabaseConfigurationException {
        Path dir = this.getDataDir().resolve(this.getDirName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening Lucene index directory: " + dir.toAbsolutePath().toString());
        }
        IndexWriter writer = null;
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                if (!Files.isDirectory(dir, new LinkOption[0])) {
                    throw new DatabaseConfigurationException("Lucene index location is not a directory: " + dir.toAbsolutePath().toString());
                }
            } else {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            this.directory = FSDirectory.open((File)dir.toFile());
            IndexWriterConfig idxWriterConfig = new IndexWriterConfig(LUCENE_VERSION_IN_USE, this.defaultAnalyzer);
            idxWriterConfig.setRAMBufferSizeMB(this.bufferSize);
            this.cachedWriter = new IndexWriter(this.directory, idxWriterConfig);
            this.searcherManager = new SearcherManager(this.cachedWriter, true, null);
            this.readerManager = new ReaderManager(this.cachedWriter, true);
        }
        catch (IOException e) {
            throw new DatabaseConfigurationException("Exception while reading lucene index directory: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseWriter(writer);
        }
    }

    public synchronized void close() throws DBException {
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
                this.searcherManager = null;
            }
            if (this.readerManager != null) {
                this.readerManager.close();
                this.readerManager = null;
            }
            if (this.cachedWriter != null) {
                this.commit();
                this.cachedWriter.close();
                this.cachedWriter = null;
            }
            this.directory.close();
        }
        catch (IOException e) {
            throw new DBException("Caught exception while closing lucene indexes: " + e.getMessage());
        }
    }

    public synchronized void sync() throws DBException {
        this.commit();
    }

    public void remove() throws DBException {
        this.close();
        Path dir = this.getDataDir().resolve(this.getDirName());
        try {
            Files.list(dir).forEach(path -> FileUtils.deleteQuietly((Path)path));
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public IndexWorker getWorker(DBBroker broker) {
        return new LuceneIndexWorker(this, broker);
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    protected Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public IndexWriter getWriter() throws IOException {
        return this.getWriter(false);
    }

    public IndexWriter getWriter(boolean exclusive) throws IOException {
        return this.cachedWriter;
    }

    public synchronized void releaseWriter(IndexWriter writer) {
        if (writer == null) {
            return;
        }
        this.needsCommit = true;
    }

    protected void commit() {
        if (!this.needsCommit) {
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Committing lucene index");
            }
            if (this.cachedWriter != null) {
                this.cachedWriter.commit();
            }
            this.needsCommit = false;
        }
        catch (CorruptIndexException cie) {
            LOG.error("Detected corrupt Lucence index on writer release and commit: " + cie.getMessage(), (Throwable)cie);
        }
        catch (IOException ioe) {
            LOG.error("Detected Lucence index issue on writer release and commit: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withReader(FunctionE<IndexReader, R, IOException> fn) throws IOException {
        this.readerManager.maybeRefreshBlocking();
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            Object object = fn.apply((Object)reader);
            return (R)object;
        }
        finally {
            this.readerManager.release((Object)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withSearcher(Function2E<IndexSearcher, R, IOException, XPathException> consumer) throws IOException, XPathException {
        this.searcherManager.maybeRefreshBlocking();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Object object = consumer.apply((Object)searcher);
            return (R)object;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupToArchive(RawDataBackup backup) throws IOException {
        for (String name : this.directory.listAll()) {
            String path = this.getDirName() + "/" + name;
            try {
                OutputStream os = backup.newEntry(path);
                Files.copy(this.getDataDir().resolve(path), os);
            }
            finally {
                backup.closeEntry();
            }
        }
    }
}

