/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.exist.dom.QName;
import org.exist.dom.persistent.SymbolTable;
import org.exist.numbering.NodeId;
import org.exist.storage.BrokerPool;
import org.exist.util.ByteConversion;

public class LuceneUtil {
    public static final String FIELD_NODE_ID = "nodeId";
    public static final String FIELD_DOC_ID = "docId";
    public static final String FIELD_DOC_URI = "docUri";
    private static final MultiTermExtractor TERM_EXTRACTOR = new MultiTermExtractor();

    public static byte[] createId(int docId, NodeId nodeId) {
        byte[] data = new byte[nodeId.size() + 4];
        ByteConversion.intToByteH((int)docId, (byte[])data, (int)0);
        nodeId.serialize(data, 4);
        return data;
    }

    public static byte[] createId(NodeId nodeId) {
        byte[] data = new byte[nodeId.size()];
        nodeId.serialize(data, 0);
        return data;
    }

    public static NodeId readNodeId(int doc, BinaryDocValues nodeIdValues, BrokerPool pool) {
        BytesRef ref = nodeIdValues.get(doc);
        short units = ByteConversion.byteToShort((byte[])ref.bytes, (int)ref.offset);
        return pool.getNodeFactory().createFromData((int)units, ref.bytes, ref.offset + 2);
    }

    public static String encodeQName(QName qname, SymbolTable symbols) {
        short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
        short localNameId = symbols.getSymbol(qname.getLocalPart());
        long nameId = (long)(qname.getNameType() | (namespaceId & 0xFFFF) << 16) | ((long)localNameId & 0xFFFFFFFFL) << 32;
        return Long.toHexString(nameId);
    }

    public static QName decodeQName(String s, SymbolTable symbols) {
        try {
            long l = Long.parseLong(s, 16);
            short namespaceId = (short)(l >>> 16 & 0xFFFFL);
            short localNameId = (short)(l >>> 32 & 0xFFFFL);
            byte type = (byte)(l & 0xFFL);
            String namespaceURI = symbols.getNamespace(namespaceId);
            String localName = symbols.getName(localNameId);
            return new QName(localName, namespaceURI, "", type);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String[] extractFields(Query query, IndexReader reader) throws IOException {
        TreeMap<Object, Query> map = new TreeMap<Object, Query>();
        LuceneUtil.extractTerms(query, map, reader, true);
        TreeSet<String> fields = new TreeSet<String>();
        for (Object term : map.keySet()) {
            fields.add(((Term)term).field());
        }
        String[] fieldArray = new String[fields.size()];
        return fields.toArray(fieldArray);
    }

    public static void extractTerms(Query query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException, UnsupportedOperationException {
        if (query instanceof BooleanQuery) {
            LuceneUtil.extractTermsFromBoolean((BooleanQuery)query, terms, reader, includeFields);
        } else if (query instanceof TermQuery) {
            LuceneUtil.extractTermsFromTerm((TermQuery)query, terms, includeFields);
        } else if (query instanceof WildcardQuery) {
            LuceneUtil.extractTermsFromWildcard((WildcardQuery)query, terms, reader, includeFields);
        } else if (query instanceof RegexpQuery) {
            LuceneUtil.extractTermsFromRegex((RegexpQuery)query, terms, reader, includeFields);
        } else if (query instanceof FuzzyQuery) {
            LuceneUtil.extractTermsFromFuzzy((FuzzyQuery)query, terms, reader, includeFields);
        } else if (query instanceof PrefixQuery) {
            LuceneUtil.extractTermsFromPrefix((PrefixQuery)query, terms, reader, includeFields);
        } else if (query instanceof PhraseQuery) {
            LuceneUtil.extractTermsFromPhrase((PhraseQuery)query, terms, includeFields);
        } else {
            TreeSet tempSet = new TreeSet();
            query.extractTerms(tempSet);
            for (Term t : tempSet) {
                if (includeFields) {
                    terms.put(t, query);
                    continue;
                }
                terms.put(t.text(), query);
            }
        }
    }

    private static void extractTermsFromBoolean(BooleanQuery query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException {
        BooleanClause[] clauses;
        for (BooleanClause clause : clauses = query.getClauses()) {
            LuceneUtil.extractTerms(clause.getQuery(), terms, reader, includeFields);
        }
    }

    private static void extractTermsFromTerm(TermQuery query, Map<Object, Query> terms, boolean includeFields) {
        if (includeFields) {
            terms.put(query.getTerm(), (Query)query);
        } else {
            terms.put(query.getTerm().text(), (Query)query);
        }
    }

    private static void extractTermsFromWildcard(WildcardQuery query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException {
        LuceneUtil.extractTermsFromMultiTerm((MultiTermQuery)query, terms, reader, includeFields);
    }

    private static void extractTermsFromRegex(RegexpQuery query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException {
        LuceneUtil.extractTermsFromMultiTerm((MultiTermQuery)query, terms, reader, includeFields);
    }

    private static void extractTermsFromFuzzy(FuzzyQuery query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException {
        LuceneUtil.extractTermsFromMultiTerm((MultiTermQuery)query, terms, reader, includeFields);
    }

    private static void extractTermsFromPrefix(PrefixQuery query, Map<Object, Query> terms, IndexReader reader, boolean includeFields) throws IOException {
        LuceneUtil.extractTermsFromMultiTerm((MultiTermQuery)query, terms, reader, includeFields);
    }

    private static void extractTermsFromPhrase(PhraseQuery query, Map<Object, Query> terms, boolean includeFields) {
        Term[] t;
        for (Term t1 : t = query.getTerms()) {
            if (includeFields) {
                terms.put(t1, (Query)query);
                continue;
            }
            terms.put(t1.text(), (Query)query);
        }
    }

    private static Query rewrite(MultiTermQuery query, IndexReader reader) throws IOException {
        query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        return query.rewrite(reader);
    }

    private static void extractTermsFromMultiTerm(MultiTermQuery query, Map<Object, Query> termsMap, IndexReader reader, boolean includeFields) throws IOException {
        TERM_EXTRACTOR.extractTerms(query, termsMap, reader, includeFields);
    }

    private static class MultiTermExtractor
    extends MultiTermQuery.RewriteMethod {
        private MultiTermExtractor() {
        }

        public void extractTerms(MultiTermQuery query, Map<Object, Query> termsMap, IndexReader reader, boolean includeFields) throws IOException {
            IndexReaderContext topReaderContext = reader.getContext();
            for (AtomicReaderContext context : topReaderContext.leaves()) {
                BytesRef bytes;
                Terms terms;
                Fields fields = context.reader().fields();
                if (fields == null || (terms = fields.terms(query.getField())) == null) continue;
                TermsEnum termsEnum = this.getTermsEnum(query, terms, new AttributeSource());
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY) continue;
                while ((bytes = termsEnum.next()) != null) {
                    Term term = new Term(query.getField(), BytesRef.deepCopyOf((BytesRef)bytes));
                    if (includeFields) {
                        termsMap.put(term, (Query)query);
                        continue;
                    }
                    termsMap.put(term.text(), (Query)query);
                }
            }
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

