/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeSource;

public class MarkableTokenFilter
extends TokenFilter {
    private List<AttributeSource.State> cache = null;
    private Iterator<AttributeSource.State> iterator = null;
    private AttributeSource.State finalState;
    private boolean isCaching = false;

    public MarkableTokenFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public void mark() {
        this.isCaching = true;
        this.cache = new LinkedList<AttributeSource.State>();
    }

    public void reset() throws IOException {
        this.isCaching = false;
        if (this.cache != null) {
            this.iterator = this.cache.iterator();
        }
    }

    public final void end() throws IOException {
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    public final boolean incrementToken() throws IOException {
        if (this.isCaching) {
            if (!this.input.incrementToken()) {
                this.input.end();
                this.finalState = this.captureState();
                return false;
            }
            this.cache.add(this.captureState());
            return true;
        }
        if (this.cache == null) {
            if (!this.input.incrementToken()) {
                this.input.end();
                this.finalState = this.captureState();
                return false;
            }
            return true;
        }
        if (!this.iterator.hasNext()) {
            this.cache = null;
            return false;
        }
        this.restoreState(this.iterator.next());
        return true;
    }
}

