/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.AttributeSource;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.indexing.lucene.LuceneUtil;
import org.exist.indexing.lucene.MarkableTokenFilter;

public class PlainTextHighlighter {
    private final TreeMap<Object, Query> termMap = new TreeMap();

    public PlainTextHighlighter(Query query, IndexReader reader) throws IOException {
        LuceneUtil.extractTerms(query, this.termMap, reader, false);
    }

    public void highlight(String content, List<Offset> offsets, MemTreeBuilder builder) {
        if (offsets == null || offsets.isEmpty()) {
            builder.characters((CharSequence)content);
        } else {
            int lastOffset = 0;
            for (Offset offset : offsets) {
                if (offset.startOffset() > lastOffset) {
                    builder.characters((CharSequence)content.substring(lastOffset, offset.startOffset()));
                }
                builder.startElement("http://exist.sourceforge.net/NS/exist", "match", "exist:match", null);
                builder.characters((CharSequence)content.substring(offset.startOffset(), offset.endOffset()));
                builder.endElement();
                lastOffset = offset.endOffset();
            }
            if (lastOffset < content.length()) {
                builder.characters((CharSequence)content.substring(lastOffset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Offset> getOffsets(String content, Analyzer analyzer) throws IOException {
        TokenStream tokenStream = analyzer.tokenStream(null, (Reader)new StringReader(content));
        tokenStream.reset();
        ArrayList<Offset> offsets = null;
        try (MarkableTokenFilter stream = new MarkableTokenFilter(tokenStream);){
            boolean lastOffset = false;
            while (stream.incrementToken()) {
                String text = ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString();
                Query termQuery = this.termMap.get(text);
                if (termQuery == null) continue;
                if (termQuery instanceof PhraseQuery) {
                    PhraseQuery phraseQuery = (PhraseQuery)termQuery;
                    Term[] terms = phraseQuery.getTerms();
                    if (!text.equals(terms[0].text())) continue;
                    stream.mark();
                    int t = 1;
                    ArrayList<AttributeSource.State> stateList = new ArrayList<AttributeSource.State>(terms.length);
                    stateList.add(stream.captureState());
                    while (stream.incrementToken() && t < terms.length) {
                        text = ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString();
                        if (text.equals(terms[t].text())) {
                            stateList.add(stream.captureState());
                            if (++t != terms.length) continue;
                            break;
                        }
                        stream.reset();
                        break;
                    }
                    if (stateList.size() != terms.length) continue;
                    if (offsets == null) {
                        offsets = new ArrayList();
                    }
                    stream.restoreState((AttributeSource.State)stateList.get(0));
                    int start = ((OffsetAttribute)stream.getAttribute(OffsetAttribute.class)).startOffset();
                    stream.restoreState((AttributeSource.State)stateList.get(terms.length - 1));
                    int end = ((OffsetAttribute)stream.getAttribute(OffsetAttribute.class)).endOffset();
                    offsets.add(new Offset(start, end));
                    stream.restoreState((AttributeSource.State)stateList.get(stateList.size() - 1));
                    continue;
                }
                if (offsets == null) {
                    offsets = new ArrayList<Offset>();
                }
                OffsetAttribute offsetAttr = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
                offsets.add(new Offset(offsetAttr.startOffset(), offsetAttr.endOffset()));
            }
        }
        return offsets;
    }

    public static class Offset {
        protected int startOffset;
        protected int endOffset;

        Offset(int start, int end) {
            this.startOffset = start;
            this.endOffset = end;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }
    }
}

