/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.util.ArrayList;
import org.apache.lucene.document.Field;
import org.exist.dom.memtree.NodeImpl;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.xquery.value.NodeValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlainTextIndexConfig {
    private PlainTextDoc solrDoc = new PlainTextDoc();
    private ArrayList<PlainTextField> solrFields = new ArrayList();

    private float getFloatValue(String value) {
        float retVal = 1.0f;
        if (value != null && value.length() > 0) {
            try {
                retVal = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                LuceneIndexWorker.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return retVal;
    }

    boolean parse(NodeValue descriptor) {
        Node doc;
        if (descriptor.getImplementationType() == 0) {
            ((NodeImpl)descriptor).expand();
        }
        if (!(doc = descriptor.getNode()).getLocalName().contentEquals("doc")) {
            LuceneIndexWorker.LOG.error("Expected <doc> got <" + descriptor.getNode().getLocalName() + ">");
            return false;
        }
        NamedNodeMap nnm = doc.getAttributes();
        Node attributeNode = nnm.getNamedItem("boost");
        if (attributeNode != null) {
            this.solrDoc.setBoost(this.getFloatValue(attributeNode.getNodeValue()));
        }
        ArrayList<PlainTextField> fields = this.getFields();
        NodeList nodeList = descriptor.getNode().getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nodeList.item(i);
            String childname = child.getLocalName();
            if (!"field".equals(childname)) {
                LuceneIndexWorker.LOG.error("Expected <field> got <" + childname + ">");
                continue;
            }
            PlainTextField field = new PlainTextField();
            fields.add(field);
            nnm = child.getAttributes();
            attributeNode = nnm.getNamedItem("name");
            if (attributeNode == null) {
                LuceneIndexWorker.LOG.error("No name attribute");
                continue;
            }
            String name = attributeNode.getNodeValue();
            field.setName(name);
            attributeNode = nnm.getNamedItem("boost");
            if (attributeNode != null) {
                String boost = attributeNode.getNodeValue();
                field.setBoost(this.getFloatValue(boost));
            }
            if ((attributeNode = nnm.getNamedItem("store")) != null) {
                String val = attributeNode.getNodeValue();
                boolean store = val != null && val.equalsIgnoreCase("yes");
                field.setStore(store);
            }
            String content = child.getTextContent();
            field.setContent(content);
        }
        return true;
    }

    ArrayList<PlainTextField> getFields() {
        return this.solrFields;
    }

    private void setFields(ArrayList<PlainTextField> solrField) {
        this.solrFields = solrField;
    }

    PlainTextDoc getDoc() {
        return this.solrDoc;
    }

    private void setDoc(PlainTextDoc doc) {
        this.solrDoc = doc;
    }

    public static class PlainTextDoc {
        private float boost = 1.0f;

        void setBoost(float value) {
            this.boost = value;
        }

        public float getBoost() {
            return this.boost;
        }
    }

    public static class PlainTextField {
        private Field.Store store = Field.Store.NO;
        private String name;
        private float boost = 1.0f;
        private CharSequence data;

        void setStore(boolean setStore) {
            this.store = setStore ? Field.Store.YES : Field.Store.NO;
        }

        void setName(String name) {
            this.name = name;
        }

        void setBoost(float value) {
            this.boost = value;
        }

        void setContent(CharSequence value) {
            this.data = value;
        }

        public float getBoost() {
            return this.boost;
        }

        public CharSequence getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public Field.Store getStore() {
            return this.store;
        }
    }
}

