/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.search.Query;
import org.exist.xquery.XPathException;

public abstract class QueryParserWrapper {
    private static final Logger LOG = LogManager.getLogger(QueryParserWrapper.class);

    public QueryParserWrapper(String field, Analyzer analyzer) {
    }

    public abstract CommonQueryParserConfiguration getConfiguration();

    public abstract Query parse(String var1) throws XPathException;

    public static QueryParserWrapper create(String className, String field, Analyzer analyzer) {
        try {
            Class<?> clazz = Class.forName(className);
            if (QueryParserWrapper.class.isAssignableFrom(clazz)) {
                Class[] cParamClasses = new Class[]{String.class, Analyzer.class};
                Constructor<?> cstr = clazz.getDeclaredConstructor(cParamClasses);
                return (QueryParserWrapper)cstr.newInstance(field, analyzer);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Failed to instantiate lucene query parser wrapper class: " + className, (Throwable)e);
        }
        return null;
    }
}

