/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.indexing.StreamListener;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Index
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(Index.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index", "http://exist-db.org/xquery/lucene", "ft"), "Index an arbitrary chunk of (non-XML) data with Lucene. Syntax is inspired by Solr.", new SequenceType[]{new FunctionParameterSequenceType("documentPath", 22, 2, "URI path of document in database."), new FunctionParameterSequenceType("solrExression", -1, 2, "XML syntax expected by Solr's add expression. Element should be called 'doc', e.g.<doc> <field name=\"field1\">data1</field> <field name=\"field2\" boost=\"value\">data2</field> </doc> ")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "")), new FunctionSignature(new QName("index", "http://exist-db.org/xquery/lucene", "ft"), "Index an arbitrary chunk of (non-XML) data with Lucene. Syntax is inspired by Solr.", new SequenceType[]{new FunctionParameterSequenceType("documentPath", 22, 2, "URI path of document in database."), new FunctionParameterSequenceType("solrExression", -1, 2, "XML syntax expected by Solr's add expression. Element should be called 'doc', e.g.<doc> <field name=\"field1\">data1</field> <field name=\"field2\" boost=\"value\">data2</field> </doc> "), new FunctionParameterSequenceType("close", 23, 2, "If true, close the Lucene document. Subsequent calls to ft:index will thus add to a new Lucene document. If false, the document remains open and is not flushed to disk. Call the ft:close function to explicitely close and flush the current document.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "")), new FunctionSignature(new QName("close", "http://exist-db.org/xquery/lucene", "ft"), "Close the current Lucene document and flush it to disk. Subsequent calls to ft:index will write to a new Lucene document.", null, (SequenceType)new FunctionReturnSequenceType(10, 1, ""))};

    public Index(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DocumentImpl doc = null;
        try {
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            if (this.isCalledAs("index")) {
                String path = args[0].itemAt(0).getStringValue();
                doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor((String)path), Lock.LockMode.READ_LOCK);
                if (doc == null) {
                    throw new XPathException("Document " + path + " does not exist.");
                }
                boolean flush = args.length == 2 || args[2].effectiveBooleanValue();
                index.setDocument(doc, StreamListener.ReindexMode.STORE);
                index.setMode(StreamListener.ReindexMode.STORE);
                NodeValue descriptor = (NodeValue)args[1].itemAt(0);
                index.indexNonXML(descriptor);
                if (flush) {
                    index.writeNonXML();
                }
            } else {
                index.writeNonXML();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new XPathException((Throwable)ex);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

