/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import org.exist.dom.QName;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Optimize
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("optimize", "http://exist-db.org/xquery/lucene", "ft"), "Calls Lucene's optimize method to merge all index segments into a single one. This is a costly operation and should not be used except for data sets which can be expected to remain unchanged for a while. The optimize will block the index for other write operations and may take some time. You need to be a user in group dba to call this function.", new SequenceType[0], (SequenceType)new FunctionReturnSequenceType(10, 1, ""));

    public Optimize(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getUser().hasDbaRole()) {
            throw new XPathException((Expression)this, "user has to be a member of the dba group to call the optimize function. Calling user was " + this.context.getUser().getName());
        }
        LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
        index.optimize();
        return Sequence.EMPTY_SEQUENCE;
    }
}

