/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryparser.classic.ParseException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.lucene.Query;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;

public class QueryField
extends Query
implements Optimizable {
    protected static final Logger logger = LogManager.getLogger(Query.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("query-field", "http://exist-db.org/xquery/lucene", "ft"), "Queries a Lucene field, which has to be explicitely created in the index configuration.", new SequenceType[]{new FunctionParameterSequenceType("field", 22, 7, "The lucene field name."), new FunctionParameterSequenceType("query", 11, 2, "The query to search for, provided either as a string or text in Lucene's default query syntax or as an XML fragment to bypass Lucene's default query parser")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set matching the query. match highlighting information will be available for all returned nodes. Lucene's match score can be retrieved via the ft:score function.")), new FunctionSignature(new QName("query-field", "http://exist-db.org/xquery/lucene", "ft"), "Queries a Lucene field, which has to be explicitely created in the index configuration.", new SequenceType[]{new FunctionParameterSequenceType("field", 22, 7, "The lucene field name."), new FunctionParameterSequenceType("query", 11, 2, "The query to search for, provided either as a string or text in Lucene's default query syntax or as an XML fragment to bypass Lucene's default query parser"), new FunctionParameterSequenceType("options", -1, 3, "An XML fragment containing options to be passed to Lucene's query parser. The following options are supported (a description can be found in the docs):\n<options>\n   <default-operator>and|or</default-operator>\n   <phrase-slop>number</phrase-slop>\n   <leading-wildcard>yes|no</leading-wildcard>\n   <filter-rewrite>yes|no</filter-rewrite>\n</options>")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set matching the query. match highlighting information will be available for all returned nodes. Lucene's match score can be retrieved via the ft:score function."))};
    private NodeSet preselectResult = null;

    public QueryField(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(new AnalyzeContextInfo(contextInfo));
        this.contextId = contextInfo.getContextId();
    }

    @Override
    public boolean canOptimize(Sequence contextSequence) {
        return true;
    }

    @Override
    public int getOptimizeAxis() {
        return 8;
    }

    @Override
    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        long start = System.currentTimeMillis();
        this.preselectResult = null;
        LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
        String field = this.getArgument(0).eval(contextSequence).getStringValue();
        DocumentSet docs = contextSequence.getDocumentSet();
        Item query = this.getKey(contextSequence, null);
        Properties options = this.parseOptions(contextSequence, null);
        try {
            this.preselectResult = Type.subTypeOf((int)query.getType(), (int)1) ? index.queryField(this.context, this.getExpressionId(), docs, useContext ? contextSequence.toNodeSet() : null, field, (Element)((NodeValue)query).getNode(), 1, options) : index.queryField(this.context, this.getExpressionId(), docs, useContext ? contextSequence.toNodeSet() : null, field, query.getStringValue(), 1, options);
        }
        catch (IOException | ParseException e) {
            throw new XPathException((Expression)this, "Error while querying full text index: " + e.getMessage(), e);
        }
        LOG.debug("Lucene query took " + (System.currentTimeMillis() - start));
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "lucene", (Expression)this, 2, System.currentTimeMillis() - start);
        }
        return this.preselectResult;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.preselectResult == null) {
            long start = System.currentTimeMillis();
            String field = this.getArgument(0).eval(contextSequence).getStringValue();
            Item query = this.getKey(contextSequence, null);
            DocumentSet docs = null;
            docs = contextSequence == null ? this.context.getStaticallyKnownDocuments() : contextSequence.getDocumentSet();
            NodeSet contextSet = null;
            if (contextSequence != null) {
                contextSet = contextSequence.toNodeSet();
            }
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            Properties options = this.parseOptions(contextSequence, contextItem);
            try {
                result = Type.subTypeOf((int)query.getType(), (int)1) ? index.queryField(this.context, this.getExpressionId(), docs, contextSet, field, (Element)((NodeValue)query).getNode(), 0, options) : index.queryField(this.context, this.getExpressionId(), docs, contextSet, field, query.getStringValue(), 0, options);
            }
            catch (IOException | ParseException e) {
                throw new XPathException((Expression)this, e.getMessage());
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceIndexUsage(this.context, "lucene", (Expression)this, 1, System.currentTimeMillis() - start);
            }
        } else {
            result = this.preselectResult.selectAncestorDescendant(contextSequence.toNodeSet(), 1, true, this.getContextId(), true);
        }
        return result;
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.preselectResult = null;
        }
    }
}

