/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.indexing.StreamListener;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RemoveIndex
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("remove-index", "http://exist-db.org/xquery/lucene", "ft"), "Remove any (non-XML) Lucene index associated with the document identified by the path parameter. This function will only remove indexes which were manually created by the user via the ft:index function. Indexes defined in collection.xconf will NOT be removed. They are maintained automatically by the database. Please note that non-XML indexes will also be removed automatically if the associated document is deleted.", new SequenceType[]{new FunctionParameterSequenceType("documentPath", 22, 2, "URI path of document in database.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, ""));

    public RemoveIndex(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DocumentImpl doc = null;
        try {
            String path = args[0].itemAt(0).getStringValue();
            doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor((String)path), Lock.LockMode.READ_LOCK);
            if (doc == null) {
                throw new XPathException("Document " + path + " does not exist.");
            }
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            index.setDocument(doc, StreamListener.ReindexMode.REMOVE_BINARY);
            index.flush();
        }
        catch (Exception ex) {
            throw new XPathException((Throwable)ex);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

