/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Score
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Score.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("score", "http://exist-db.org/xquery/lucene", "ft"), "Returns a computed relevance score for the given node. The score is the sum of all relevance scores provided by Lucene for the node and its descendants. In general, the score will be a number between 0.0 and 1.0 if the query had $node as context. If the query targeted multiple descendants of $node (e.g. 'title' and 'author' within a 'book'), the score will be the sum of all sub-scores and may thus be greater than 1.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 2, "the context node")}, (SequenceType)new FunctionReturnSequenceType(33, 7, "sum of all relevance scores provided by Lucene for all matches below the given context node"));

    public Score(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue nodeValue = (NodeValue)args[0].itemAt(0);
        if (nodeValue.getImplementationType() != 1) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeProxy proxy = (NodeProxy)nodeValue;
        float score = 0.0f;
        for (Match match = proxy.getMatches(); match != null; match = match.getNextMatch()) {
            if (match.getIndexId() != LuceneIndex.ID) continue;
            float currentScore = ((LuceneIndexWorker.LuceneMatch)match).getScore();
            score += currentScore;
        }
        return new FloatValue(score);
    }
}

