/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class Search
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(Search.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("search", "http://exist-db.org/xquery/lucene", "ft"), "Search for (non-XML) data with lucene", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 7, "URI paths of documents or collections in database. Collection URIs should end on a '/'."), new FunctionParameterSequenceType("query", 22, 2, "query string"), new FunctionParameterSequenceType("fields", 22, 7, "Fields to return in search results")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "All documents that are match by the query")), new FunctionSignature(new QName("search", "http://exist-db.org/xquery/lucene", "ft"), "Search for (non-XML) data with lucene", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 7, "URI paths of documents or collections in database. Collection URIs should end on a '/'."), new FunctionParameterSequenceType("query", 22, 2, "query string")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "All documents that are match by the query")), new FunctionSignature(new QName("search", "http://exist-db.org/xquery/lucene", "ft"), "Search for (non-XML) data with lucene", new SequenceType[]{new FunctionParameterSequenceType("query", 22, 2, "query string")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "All documents that are match by the query"))};

    public Search(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeImpl report = null;
        try {
            Sequence pathSeq;
            ArrayList<String> toBeMatchedURIs = new ArrayList<String>();
            Sequence sequence = pathSeq = this.getArgumentCount() > 1 ? args[0] : contextSequence;
            if (pathSeq == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            SequenceIterator i = pathSeq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                String path = Type.subTypeOf((int)item.getType(), (int)-1) ? (((NodeValue)item).isPersistentSet() ? ((NodeProxy)item).getOwnerDocument().getURI().toString() : item.getStringValue()) : item.getStringValue();
                toBeMatchedURIs.add(path);
            }
            String query = this.getArgumentCount() == 1 ? args[0].itemAt(0).getStringValue() : args[1].itemAt(0).getStringValue();
            String[] fields = null;
            if (this.getArgumentCount() == 3) {
                fields = new String[args[2].getItemCount()];
                int j = 0;
                SequenceIterator i2 = args[2].iterate();
                while (i2.hasNext()) {
                    fields[j++] = i2.nextItem().getStringValue();
                }
            }
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            report = index.search(this.context, toBeMatchedURIs, query, fields);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        catch (XPathException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return report;
    }

    public int getDependencies() {
        return 1;
    }
}

