/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr.linereader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.util.cr.linereader.LineHandler;

@SofaCapability(outputSofas={"UriView"})
public class LineReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_FILE_OR_DIRECTORY_NAME = "fileOrDirectoryName";
    @ConfigurationParameter(name="fileOrDirectoryName", mandatory=true, description="Takes either the name of a single file or the root directory containing all the files to be processed.")
    private String fileOrDirectoryName;
    public static final String PARAM_VIEW_NAME = "viewName";
    @ConfigurationParameter(name="viewName", mandatory=false, description="takes the the name that should be given to the JCas view associated with the document texts.", defaultValue={"_InitialView"})
    private String viewName;
    public static final String PARAM_LANGUAGE = "language";
    @ConfigurationParameter(name="language", mandatory=false, description="takes the language code corresponding to the language of the documents being examined. The value of this parameter is simply passed on to JCas.setDocumentLanguage(String)")
    private String language;
    public static final String PARAM_ENCODING = "encoding";
    @ConfigurationParameter(name="encoding", mandatory=false, description="takes the encoding of the text files (e.g. 'UTF-8').  See apidocs for java.nio.charset.Charset for a list of encoding names.")
    private String encoding;
    public static final String PARAM_SUFFIXES = "suffixes";
    @ConfigurationParameter(name="suffixes", mandatory=false, description="Takes suffixes (e.g. .txt) of the files that should be read in.")
    private String[] suffixes;
    public static final String PARAM_LINE_HANDLER_CLASS_NAME = "lineHandlerClassName";
    @ConfigurationParameter(name="lineHandlerClassName", mandatory=false, description="specifies the class name of the LineHandler. If one is not specified, then the DefaultLineHandler will be used.", defaultValue={"org.cleartk.util.cr.linereader.DefaultLineHandler"})
    private String lineHandlerClassName;
    public static final String PARAM_COMMENT_SPECIFIERS = "commentSpecifiers";
    @ConfigurationParameter(name="commentSpecifiers", mandatory=false, description="Specifies lines that should be considered 'comments' - i.e. lines that should be skipped. Commented lines are those the start with one of the values of this parameter.")
    private String[] commentSpecifiers;
    public static final String PARAM_SKIP_BLANK_LINES = "skipBlankLines";
    @ConfigurationParameter(name="skipBlankLines", mandatory=false, description="Specifies whether blank lines should be skipped or not. The default value is true if no value is given. If this parameter is set to false, then blank lines that appear in the text files will be read in and given their own JCas.  Blank lines are those that consist of only whitespace.", defaultValue={"true"})
    private boolean skipBlankLines;
    File file;
    int lineNumber;
    String line;
    BufferedReader input;
    LineHandler lineHandler;
    private File rootFile;
    private Iterator<?> files;
    private int completed = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            this.rootFile = new File(this.fileOrDirectoryName);
            if (!this.rootFile.exists()) {
                String format = "file or directory %s does not exist";
                String message = String.format(format, this.fileOrDirectoryName);
                throw new ResourceInitializationException((Throwable)new IOException(message));
            }
            this.files = this.rootFile.isDirectory() ? (this.suffixes != null && this.suffixes.length > 0 ? FileUtils.iterateFiles((File)this.rootFile, (IOFileFilter)new SuffixFileFilter(this.suffixes), (IOFileFilter)TrueFileFilter.INSTANCE) : FileUtils.iterateFiles((File)this.rootFile, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) : Arrays.asList(this.rootFile).iterator();
            if (this.commentSpecifiers == null) {
                this.commentSpecifiers = new String[0];
            }
            this.lineHandler = (LineHandler)InitializableFactory.create((UimaContext)this.getUimaContext(), (String)this.lineHandlerClassName, LineHandler.class);
            this.moveToNextFile();
        }
        catch (Exception fnfe) {
            throw new ResourceInitializationException((Throwable)fnfe);
        }
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        JCas view;
        this.hasNext();
        try {
            view = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)this.viewName);
        }
        catch (AnalysisEngineProcessException e) {
            throw new CollectionException((Throwable)e);
        }
        this.lineHandler.handleLine(view, this.rootFile, this.file, this.line);
        if (this.language != null) {
            view.setDocumentLanguage(this.language);
        }
        ++this.completed;
        this.line = null;
    }

    private boolean moveToNextFile() throws FileNotFoundException, UnsupportedEncodingException {
        if (this.files.hasNext()) {
            this.file = (File)this.files.next();
            this.input = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            this.lineNumber = 0;
            return true;
        }
        return false;
    }

    public Progress[] getProgress() {
        ProgressImpl progress = new ProgressImpl(this.completed, 1000000, "entities");
        return new Progress[]{progress};
    }

    public boolean hasNext() throws IOException, CollectionException {
        if (this.line == null) {
            this.line = this.input.readLine();
            if (this.line != null) {
                for (String commentSpecifier : this.commentSpecifiers) {
                    if (!this.line.startsWith(commentSpecifier)) continue;
                    this.line = null;
                    return this.hasNext();
                }
                if (this.skipBlankLines && this.line.trim().equals("")) {
                    this.line = null;
                    return this.hasNext();
                }
            }
        }
        if (this.line == null) {
            if (this.moveToNextFile()) {
                return this.hasNext();
            }
            return false;
        }
        return true;
    }

    public void close() throws IOException {
    }
}

