/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.similarity;

public class Levenshtein {
    public static float similarity(String string1, String string2) {
        if (string1.length() == 0 && string2.length() == 0) {
            return 1.0f;
        }
        int editDistance = Levenshtein.editDistance(string1, string2);
        float similarity = (float)editDistance / (float)(string1.length() + string2.length());
        return 1.0f - Math.min(similarity, 1.0f);
    }

    public static int editDistance(String string1, String string2) {
        int rowIndex;
        int rowCount = string1.length() + 1;
        int columnCount = string2.length() + 1;
        int[][] matrix = new int[rowCount][columnCount];
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            matrix[rowIndex][0] = rowIndex;
        }
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            matrix[0][columnIndex] = columnIndex;
        }
        for (rowIndex = 1; rowIndex < matrix.length; ++rowIndex) {
            for (int columnIndex = 1; columnIndex < matrix[0].length; ++columnIndex) {
                char char2;
                char char1 = string1.charAt(rowIndex - 1);
                if (char1 == (char2 = string2.charAt(columnIndex - 1))) {
                    matrix[rowIndex][columnIndex] = matrix[rowIndex - 1][columnIndex - 1];
                    continue;
                }
                int left = matrix[rowIndex][columnIndex - 1];
                int up = matrix[rowIndex - 1][columnIndex];
                int leftUp = matrix[rowIndex - 1][columnIndex - 1];
                int distance = Math.min(left, up);
                distance = Math.min(distance, leftUp);
                matrix[rowIndex][columnIndex] = distance + 1;
            }
        }
        return matrix[rowCount - 1][columnCount - 1];
    }
}

