/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.tools.Logger;

public class FileHelper {
    private static final SimpleFileVisitor<Path> deleteDirVisitor = new DeleteDirVisitor();
    private static final Logger LOG = Logger.getLogger(FileHelper.class);

    public static void ensureDir(File dir) throws PackageException {
        if (!dir.exists()) {
            boolean res = dir.mkdir();
            if (!res) {
                throw new PackageException("Error creating the directory: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new PackageException("The directory is not a directory: " + dir);
        }
    }

    public static File makeTempDir(String prefix, File parent) throws PackageException {
        File tmp;
        Date now = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String today = fmt.format(now);
        try {
            tmp = File.createTempFile(prefix + "-" + today + "-", ".d", parent);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating a temporary file", ex);
        }
        if (!tmp.delete()) {
            throw new PackageException("Error removing the temporary file: " + tmp);
        }
        if (!tmp.mkdir()) {
            throw new PackageException("Error creating the temporary dir: " + tmp);
        }
        return tmp;
    }

    public static void renameTmpDir(File from, File to) throws PackageException {
        boolean failed;
        boolean bl = failed = !from.renameTo(to);
        if (failed && !System.getProperty("os.name").startsWith("Windows")) {
            throw new PackageException("Renaming '" + from + "' to '" + to + "' failed");
        }
        for (int i = 0; failed && i < 5; ++i) {
            System.gc();
            failed = !from.renameTo(to);
        }
        if (failed) {
            FileHelper.copyDir(from, to);
            boolean res = FileHelper.deleteQuietly(from.toPath());
            if (!res) {
                System.err.println("Error deleting dir: " + from);
            }
        }
    }

    private static void copyDir(File from, File to) throws PackageException {
        File[] files = from.listFiles();
        if (files == null) {
            throw new PackageException("Failed to list contents of " + from);
        }
        if (to.exists()) {
            throw new PackageException("Destination '" + to + "' exists");
        }
        if (!to.mkdirs()) {
            throw new PackageException("Destination '" + to + "' directory cannot be created");
        }
        if (!to.canWrite()) {
            throw new PackageException("Destination '" + to + "' cannot be written to");
        }
        for (File file : files) {
            File copied = new File(to, file.getName());
            if (file.isDirectory()) {
                FileHelper.copyDir(file, copied);
                continue;
            }
            try {
                Files.copy(file.toPath(), copied.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new PackageException("Error copying '" + file + "' to '" + copied + "'", ex);
            }
        }
    }

    public static boolean deleteQuietly(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return Files.deleteIfExists(path);
            }
            Files.walkFileTree(path, deleteDirVisitor);
            return true;
        }
        catch (IOException ioe) {
            LOG.info("Failed to delete " + path.toString(), ioe);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException e1) {
                    LOG.info("Failed to delete file " + file.toString(), new Object[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            try {
                Files.deleteIfExists(dir);
            }
            catch (IOException e) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    Files.deleteIfExists(dir);
                }
                catch (IOException e1) {
                    LOG.info("Failed to delete directory " + dir.toString(), new Object[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

