/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.FileHelper;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.tools.Logger;
import org.expath.pkg.repo.tools.PackagesTxtFile;
import org.expath.pkg.repo.tools.PackagesXmlFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemStorage
extends Storage {
    private static final Logger LOG = Logger.getLogger(FileSystemStorage.class);
    private File myRoot;
    private File myPrivate;
    private final PackagesXmlFile myXmlFile;
    private final PackagesTxtFile myTxtFile;
    private boolean myErrorIfNoContentDir = true;

    public FileSystemStorage(File root) throws PackageException {
        if (root == null) {
            throw new NullPointerException("The repository root directory is null");
        }
        if (!root.exists()) {
            String msg = "The repository root directory does not exist: " + root;
            throw new PackageException(msg);
        }
        if (!root.isDirectory()) {
            String msg = "The repository root directory is not a directory: " + root;
            throw new PackageException(msg);
        }
        this.myRoot = root;
        File dir = new File(root, ".expath-pkg");
        FileHelper.ensureDir(dir);
        this.myPrivate = dir;
        File xmlfile = new File(dir, "packages.xml");
        this.myXmlFile = new PackagesXmlFile(xmlfile);
        File txtfile = new File(dir, "packages.txt");
        this.myTxtFile = new PackagesTxtFile(txtfile);
    }

    public File getRootDirectory() {
        return this.myRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Storage.PackageResolver makePackageResolver(String rsrc_name, String abbrev) throws PackageException {
        File pkg_root = rsrc_name == null ? null : new File(this.myRoot, rsrc_name);
        return new FileSystemResolver(pkg_root, abbrev, rsrc_name);
    }

    @Override
    public Set<String> listPackageDirectories() throws PackageException {
        return this.myTxtFile.parseDirectories();
    }

    @Override
    public void beforeInstall(boolean force, UserInteractionStrategy interact) throws PackageException {
    }

    @Override
    public File makeTempDir(String prefix) throws PackageException {
        return FileHelper.makeTempDir(prefix, this.myPrivate);
    }

    @Override
    public boolean packageKeyExists(String key) throws PackageException {
        File f = new File(this.myRoot, key);
        return f.exists();
    }

    @Override
    public void storeInstallDir(File dir, String key, Package pkg) throws PackageException {
        File dest = new File(this.myRoot, key);
        FileHelper.renameTmpDir(dir, dest);
        FileSystemResolver resolver = this.getResolver(pkg);
        resolver.setPkgDir(dest);
    }

    @Override
    public void updatePackageLists(Package pkg) throws PackageException {
        FileSystemResolver resolver = this.getResolver(pkg);
        String dir = resolver.getDirName();
        this.myXmlFile.addPackage(pkg, dir);
        File txt_file = new File(this.myPrivate, "packages.txt");
        this.myTxtFile.addPackage(pkg, dir);
    }

    @Override
    public void remove(Package pkg) throws PackageException {
        FileSystemResolver resolver = this.getResolver(pkg);
        String dir = resolver.getDirName();
        this.myXmlFile.removePackageByDir(dir);
        this.myTxtFile.removePackageByDir(dir);
        FileHelper.deleteQuietly(resolver.myPkgDir.toPath());
    }

    public String toString() {
        return "File system storage in " + this.myRoot.getAbsolutePath();
    }

    public void setErrorIfNoContentDir(boolean value) {
        this.myErrorIfNoContentDir = value;
    }

    private FileSystemResolver getResolver(Package pkg) throws PackageException {
        Storage.PackageResolver base_resolver = pkg.getResolver();
        if (!(base_resolver instanceof FileSystemResolver)) {
            throw new PackageException("The package has not been installed in this storage.");
        }
        return (FileSystemResolver)base_resolver;
    }

    public class FileSystemResolver
    extends Storage.PackageResolver {
        private final String myRsrcName;
        private final String myPkgAbbrev;
        private File myPkgDir;
        private File myContentDir;

        public FileSystemResolver(File pkg_dir, String abbrev, String rsrc_name) throws PackageException {
            this.myPkgAbbrev = abbrev;
            this.myRsrcName = rsrc_name;
            this.setPkgDir(pkg_dir);
        }

        public String getResourceName() {
            return this.myRsrcName;
        }

        public URI getContentDirBaseURI() {
            return this.myContentDir.toURI();
        }

        private void setPkgDir(File dir) throws PackageException {
            this.myPkgDir = dir;
            this.myContentDir = dir == null || this.myPkgAbbrev == null ? null : this.getContenDir(dir, this.myPkgAbbrev);
        }

        private File getContenDir(File pkg_dir, String abbrev) throws PackageException {
            File old_style = new File(pkg_dir, abbrev);
            File new_style = new File(pkg_dir, "content");
            boolean old_exists = old_style.exists();
            boolean new_exists = new_style.exists();
            boolean old_isdir = old_style.isDirectory();
            boolean new_isdir = new_style.isDirectory();
            LOG.finer("Content dir ''{0}'' (exists:{1}/isdir:{2}), and ''{3}'' (exists:{4}/isdir:{5})", new_style, new_exists, new_isdir, old_style, old_exists, old_isdir);
            if (!old_exists && !new_exists) {
                String msg = "None of content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                if (FileSystemStorage.this.myErrorIfNoContentDir) {
                    throw new PackageException(msg);
                }
                return null;
            }
            if (old_exists && new_exists) {
                String msg = "Both content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            if (new_exists) {
                if (!new_isdir) {
                    String msg = "Content dir is not a directory: '" + new_style + "'";
                    LOG.info(msg, new Object[0]);
                    throw new PackageException(msg);
                }
                return new_style;
            }
            if (!old_isdir) {
                String msg = "Content dir is not a directory: '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            LOG.info("Warning: package uses old-style content dir: ''{0}''", old_style);
            return old_style;
        }

        public File resolveResourceAsFile(String path) {
            return new File(this.myPkgDir, path);
        }

        public File resolveComponentAsFile(String path) {
            if (this.myContentDir == null) {
                return null;
            }
            return new File(this.myContentDir, path);
        }

        public StreamSource resolveResource(String path) throws PackageException, Storage.NotExistException {
            return this.resolveWithin(path, this.myPkgDir);
        }

        public StreamSource resolveComponent(String path) throws PackageException, Storage.NotExistException {
            if (this.myContentDir == null) {
                return null;
            }
            return this.resolveWithin(path, this.myContentDir);
        }

        private StreamSource resolveWithin(String path, File dir) throws PackageException, Storage.NotExistException {
            LOG.fine("Trying to resolve ''{0}'' within ''{1}''", path, dir);
            File f = new File(dir, path);
            if (!f.exists()) {
                String msg = "File '" + f + "' does not exist";
                LOG.fine(msg, new Object[0]);
                throw new Storage.NotExistException(msg);
            }
            try {
                FileInputStream in = new FileInputStream(f);
                StreamSource src = new StreamSource(in);
                src.setSystemId(f.toURI().toString());
                return src;
            }
            catch (FileNotFoundException ex) {
                String msg = "File '" + f + "' exists but is not found";
                LOG.severe(msg, new Object[0]);
                throw new PackageException(msg, ex);
            }
        }

        private String getDirName() {
            return this.myPkgDir.getName();
        }
    }
}

