/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipHelper {
    private Path myZip;

    public ZipHelper(Path zip) {
        this.myZip = zip;
    }

    public Path unzipToTmpDir() throws IOException {
        Path tmpdir = Files.createTempDirectory("expath-pkg", new FileAttribute[0]);
        tmpdir.toFile().deleteOnExit();
        this.unzip(tmpdir);
        return tmpdir;
    }

    public void unzip(Path dest_dir) throws IOException {
        if (!Files.exists(dest_dir, new LinkOption[0])) {
            Files.createDirectories(dest_dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dest_dir, new LinkOption[0])) {
            throw new IOException("Destination is not a directory: " + dest_dir);
        }
        ZipFile archive = new ZipFile(this.myZip.toFile());
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            Path dest = dest_dir.resolve(entry.getName());
            Path parent = dest.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            InputStream in = archive.getInputStream(entry);
            Files.copy(in, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        archive.close();
    }
}

