/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.tools.UpdatableFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesTxtFile
extends UpdatableFile {
    private static final Pattern WHITE_LINE_RE = Pattern.compile("^[ \t\n\r]*$");

    public PackagesTxtFile(File file) throws PackageException {
        super(file);
    }

    public void addPackage(Package pkg, String pkg_dir) throws PackageException {
        String pkg_name = pkg.getName();
        String pkg_version = pkg.getVersion();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.myFile));
            StringWriter buffer = new StringWriter();
            while ((line = in.readLine()) != null) {
                if (WHITE_LINE_RE.matcher(line).matches()) continue;
                int pos = line.indexOf(32);
                String dir = line.substring(0, pos);
                int pos2 = line.indexOf(32, ++pos);
                String name = line.substring(pos, pos2);
                pos = pos2 + 1;
                pos2 = line.length();
                String version = line.substring(pos, pos2);
                if (dir.equals(pkg_dir) || name.equals(pkg_name) && version.equals(pkg_version)) continue;
                buffer.write(line);
                buffer.write("\n");
            }
            in.close();
            buffer.write(pkg_dir);
            buffer.write(" ");
            buffer.write(pkg_name);
            buffer.write(" ");
            buffer.write(pkg_version);
            buffer.write("\n");
            this.update(buffer);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + this.myFile, ex);
        }
    }

    public void removePackageByDir(String dir) throws PackageException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.myFile));
            StringWriter buffer = new StringWriter();
            while ((line = in.readLine()) != null) {
                int pos;
                String d;
                if (WHITE_LINE_RE.matcher(line).matches() || (d = line.substring(0, pos = line.indexOf(32))).equals(dir)) continue;
                buffer.write(line);
                buffer.write("\n");
            }
            in.close();
            this.update(buffer);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + this.myFile, ex);
        }
    }

    public Set<String> parseDirectories() throws PackageException {
        try {
            FileInputStream stream = new FileInputStream(this.myFile);
            return PackagesTxtFile.parseDirectories(stream);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + this.myFile, ex);
        }
    }

    public static Set<String> parseDirectories(InputStream stream) throws PackageException {
        HashSet<String> result = new HashSet<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                if (WHITE_LINE_RE.matcher(line).matches()) continue;
                int pos = line.indexOf(32);
                String dir = line.substring(0, pos);
                result.add(dir);
            }
            return result;
        }
        catch (IOException ex) {
            throw new PackageException("Error reading the package list", ex);
        }
    }

    @Override
    protected void createEmpty(Writer out) throws IOException {
        out.write("\n");
    }
}

