/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.expath.pkg.repo.PackageException;

public abstract class UpdatableFile {
    protected File myFile;

    public UpdatableFile(File file) throws PackageException {
        this.myFile = file;
        if (!this.myFile.exists()) {
            this.topCreateEmpty();
        }
    }

    protected abstract void createEmpty(Writer var1) throws IOException;

    protected void update(StringWriter content) throws PackageException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.myFile);
            byte[] bytes = content.getBuffer().toString().getBytes();
            ((OutputStream)out).write(bytes);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + this.myFile, ex);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    throw new PackageException("Error closing the file: " + this.myFile, ex);
                }
            }
        }
    }

    private void topCreateEmpty() throws PackageException {
        try {
            FileWriter out = new FileWriter(this.myFile);
            this.createEmpty(out);
            ((Writer)out).close();
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("Impossible to create the packages text list: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating the packages text list: " + this.myFile, ex);
        }
    }
}

