/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Vocabulary;

public class StatisticsFormat
extends TabularFormat<Statistics> {
    private static final long serialVersionUID = 6914760410359494163L;
    private static final int ADDITIONAL_DIGITS = 2;
    private final Locale headerLocale;
    private byte borderWidth;
    private boolean allPopulation;
    private static final short[] KEYS = new short[]{39, 38, 35, 33, 34, 48, 51};

    public static StatisticsFormat getInstance() {
        return StatisticsFormat.getInstance(Locale.getDefault());
    }

    public static StatisticsFormat getInstance(Locale locale) {
        return new StatisticsFormat(locale, locale, null);
    }

    public StatisticsFormat(Locale locale, Locale locale2, TimeZone timeZone) {
        super(locale, timeZone);
        this.headerLocale = locale2 != null ? locale2 : Locale.ROOT;
    }

    @Override
    public final Class<Statistics> getValueType() {
        return Statistics.class;
    }

    public boolean isForAllPopulation() {
        return this.allPopulation;
    }

    public void setForAllPopulation(boolean bl) {
        this.allPopulation = bl;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        ArgumentChecks.ensureBetween("borderWidth", 0, 2, n);
        this.borderWidth = (byte)n;
    }

    @Override
    public Statistics parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Statistics[]) {
            try {
                this.format((Statistics[])object, (Appendable)stringBuffer);
                return stringBuffer;
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
        return super.format(object, stringBuffer, fieldPosition);
    }

    @Override
    public void format(Statistics statistics, Appendable appendable) throws IOException {
        ArrayList<Statistics> arrayList = new ArrayList<Statistics>(3);
        while (statistics != null) {
            arrayList.add(statistics);
            statistics = statistics.differences();
        }
        this.format(arrayList.toArray(new Statistics[arrayList.size()]), appendable);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void format(Statistics[] statisticsArray, Appendable appendable) throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        char c;
        String[] stringArray = new String[statisticsArray.length];
        boolean bl = false;
        boolean bl2 = false;
        for (c = '\u0000'; c < statisticsArray.length; ++c) {
            object3 = statisticsArray[c];
            bl2 |= ((Statistics)object3).countNaN() != 0;
            object2 = ((Statistics)object3).name();
            if (object2 == null) continue;
            stringArray[c] = object2.toString(this.headerLocale);
            bl |= stringArray[c] != null;
        }
        c = '\u0000';
        object3 = this.columnSeparator;
        switch (this.borderWidth) {
            case 1: {
                c = '\u2500';
                object3 = (String)object3 + "\u2502 ";
                break;
            }
            case 2: {
                c = '\u2550';
                object3 = (String)object3 + "\u2551 ";
                break;
            }
        }
        object2 = new TableAppender(appendable, (String)object3);
        Vocabulary vocabulary = Vocabulary.getResources(this.headerLocale);
        if (c != '\u0000') {
            ((TableAppender)object2).nextLine(c);
        }
        if (bl) {
            ((TableAppender)object2).nextColumn();
            object = stringArray;
            n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                Statistics[] statisticsArray2 = object[n];
                if (statisticsArray2 != null) {
                    ((TableAppender)object2).append((CharSequence)statisticsArray2);
                    ((TableAppender)object2).setCellAlignment((byte)0);
                }
                ((TableAppender)object2).nextColumn();
            }
            ((TableAppender)object2).append(this.lineSeparator);
            if (c != '\u0000') {
                ((TableAppender)object2).nextLine(c);
            }
        }
        if ((object = this.getFormat(Double.class)) instanceof DecimalFormat) {
            ((DecimalFormat)object).applyPattern("#0");
        } else if (object instanceof NumberFormat) {
            StatisticsFormat.setFractionDigits((NumberFormat)object, 0);
        }
        n2 = 0;
        block20: for (n = 0; n < KEYS.length; ++n) {
            switch (n) {
                case 1: {
                    if (bl2) break;
                    continue block20;
                }
                case 2: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = statisticsArray[0].differences() != null ? 1 : 0;
                }
            }
            ((TableAppender)object2).setCellAlignment((byte)-1);
            ((TableAppender)object2).append(vocabulary.getString(KEYS[n])).append(':');
            for (Statistics statistics : statisticsArray) {
                void var17_17;
                switch (n) {
                    case 0: {
                        Integer n3 = statistics.count();
                        break;
                    }
                    case 1: {
                        Integer n4 = statistics.countNaN();
                        break;
                    }
                    case 2: {
                        Double d = statistics.minimum();
                        break;
                    }
                    case 3: {
                        Double d = statistics.maximum();
                        break;
                    }
                    case 4: {
                        Double d = statistics.mean();
                        break;
                    }
                    case 5: {
                        Double d = statistics.rms();
                        break;
                    }
                    case 6: {
                        Double d = statistics.standardDeviation(this.allPopulation);
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                if (n2 != 0) {
                    this.configure((Format)object, statistics);
                }
                ((TableAppender)object2).append(this.beforeFill);
                ((TableAppender)object2).nextColumn(this.fillCharacter);
                ((TableAppender)object2).append(((Format)object).format(var17_17));
                ((TableAppender)object2).setCellAlignment((byte)1);
            }
            ((TableAppender)object2).append(this.lineSeparator);
        }
        if (c != '\u0000') {
            ((TableAppender)object2).nextLine(c);
        }
        ((TableAppender)object2).flush();
    }

    private void configure(Format format, Statistics statistics) {
        double d = statistics.minimum();
        double d2 = statistics.maximum();
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        if ((d3 >= 1.0E10 || d3 <= 1.0E-4) && format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern("0.00000E00");
        } else {
            double d4 = statistics.mean();
            double d5 = 2.0 * statistics.standardDeviation(true);
            d5 = Math.min(d2, d4 + d5) - Math.max(d, d4 - d5);
            d5 = Math.max(d5 / (double)statistics.count(), Math.ulp(d3));
            if (format instanceof NumberFormat) {
                StatisticsFormat.setFractionDigits((NumberFormat)format, Math.max(0, 2 + DecimalFunctions.fractionDigitsForDelta(d5, false)));
            }
        }
    }

    private static void setFractionDigits(NumberFormat numberFormat, int n) {
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
    }
}

