/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.util.LocalizedException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;

public final class Exceptions
extends Static {
    private Exceptions() {
    }

    public static String getLocalizedMessage(Throwable throwable, Locale locale) {
        if (throwable == null) {
            return null;
        }
        if (locale != null && throwable instanceof LocalizedException) {
            return ((LocalizedException)((Object)throwable)).getLocalizedMessage(locale);
        }
        return throwable.getLocalizedMessage();
    }

    public static <T extends Throwable> T setMessage(T t, String string, boolean bl) {
        Object object;
        if (bl && (object = CharSequences.trimWhitespaces(t.getLocalizedMessage())) != null && !((String)object).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(CharSequences.trimWhitespaces(string));
            int n = stringBuilder.length();
            if (n != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n - 1))) {
                stringBuilder.append(". ");
            }
            string = stringBuilder.append((String)object).toString();
        }
        try {
            object = (Throwable)t.getClass().getConstructor(String.class).newInstance(string);
        }
        catch (Exception exception) {
            return t;
        }
        ((Throwable)object).setStackTrace(t.getStackTrace());
        return (T)object;
    }

    public static String formatChainedMessages(Locale locale, String string, Throwable throwable) {
        ArrayList<String> arrayList = null;
        String string2 = null;
        StringBuilder stringBuilder = null;
        while (throwable != null) {
            SQLException sQLException;
            String string3 = CharSequences.trimWhitespaces(Exceptions.getLocalizedMessage(throwable, locale));
            if (string3 != null && !string3.isEmpty()) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(128);
                    string2 = JDK7.lineSeparator();
                    arrayList = new ArrayList<String>(4);
                    if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                        stringBuilder.append(string);
                        arrayList.add(string);
                    }
                }
                if (!Exceptions.contains(arrayList, string3)) {
                    arrayList.add(string3);
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(string3);
                }
            }
            if (throwable instanceof SQLException && (sQLException = ((SQLException)throwable).getNextException()) != null) {
                throwable = sQLException;
                continue;
            }
            throwable = throwable.getCause();
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private static boolean contains(List<String> list, String string) {
        int n = list.size();
        while (--n >= 0) {
            int n2 = list.get(n).indexOf(string);
            if (n2 < 0) continue;
            return true;
        }
        return false;
    }
}

