/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredNamespaces;

final class FilteredStreamReader
extends StreamReaderDelegate {
    private final FilterVersion version;

    FilteredStreamReader(XMLStreamReader xMLStreamReader, FilterVersion filterVersion) {
        super(xMLStreamReader);
        this.version = filterVersion;
    }

    private String toView(String string) {
        String string2 = this.version.toView.get(string);
        return string2 != null ? string2 : string;
    }

    private String toImpl(String string) {
        String string2 = this.version.toImpl.get(string);
        return string2 != null ? string2 : string;
    }

    private QName toImpl(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = this.toImpl(string);
        if (string2 != string) {
            qName = new QName(string, qName.getLocalPart(), qName.getPrefix());
        }
        return qName;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        super.require(n, this.toView(string), string2);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new FilteredNamespaces(super.getNamespaceContext(), this.version, true);
    }

    @Override
    public QName getName() {
        return this.toImpl(super.getName());
    }

    @Override
    public QName getAttributeName(int n) {
        return this.toImpl(super.getAttributeName(n));
    }

    @Override
    public String getNamespaceURI() {
        return this.toImpl(super.getNamespaceURI());
    }

    @Override
    public String getNamespaceURI(int n) {
        return this.toImpl(super.getNamespaceURI(n));
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.toImpl(super.getNamespaceURI(string));
    }

    @Override
    public String getAttributeNamespace(int n) {
        return this.toImpl(super.getAttributeNamespace(n));
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return super.getAttributeValue(this.toView(string), string2);
    }
}

