/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredNamespaces;

final class FilteredStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter out;
    private final FilterVersion version;

    FilteredStreamWriter(XMLStreamWriter xMLStreamWriter, FilterVersion filterVersion) {
        this.out = xMLStreamWriter;
        this.version = filterVersion;
    }

    private String toView(String string) {
        String string2 = this.version.toView.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.out.writeStartElement(string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.out.writeStartElement(this.toView(string), string2);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeStartElement(string, string2, this.toView(string3));
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.out.writeEmptyElement(this.toView(string), string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeEmptyElement(string, string2, this.toView(string3));
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.out.writeEmptyElement(string);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.out.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.out.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.out.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.out.flush();
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.out.writeAttribute(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.out.writeAttribute(string, this.toView(string2), string3, string4);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeAttribute(this.toView(string), string2, string3);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.out.writeNamespace(string, this.toView(string2));
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.out.writeDefaultNamespace(this.toView(string));
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.out.writeComment(string);
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.out.writeProcessingInstruction(string);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.out.writeProcessingInstruction(string, string2);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.out.writeCData(string);
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.out.writeDTD(string);
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.out.writeEntityRef(string);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.out.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.out.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.out.writeStartDocument(string, string2);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.out.writeCharacters(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.out.writeCharacters(cArray, n, n2);
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.out.getPrefix(this.toView(string));
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.out.setPrefix(string, this.toView(string2));
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.out.setDefaultNamespace(this.toView(string));
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        namespaceContext = namespaceContext instanceof FilteredNamespaces ? ((FilteredNamespaces)namespaceContext).inverse(this.version) : new FilteredNamespaces(namespaceContext, this.version, true);
        this.out.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new FilteredNamespaces(this.out.getNamespaceContext(), this.version, false);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.out.getProperty(string);
    }
}

