/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.Value;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.xquery.TerminatedException;

public class BTreeTest {
    private Path file = Paths.get(System.getProperty("exist.home", "."), new String[0]).resolve("test/test.dbx");
    private BrokerPool pool = null;

    public BTreeTest() {
        try {
            Configuration config = new Configuration();
            BrokerPool.configure(1, 5, config);
            this.pool = BrokerPool.getInstance();
        }
        catch (DatabaseConfigurationException e) {
            e.printStackTrace();
        }
        catch (EXistException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.pool.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int count) throws DBException, IOException {
        FileUtils.deleteQuietly(this.file);
        try (BTree btree = null;){
            btree = new BTree(this.pool, 0, false, this.pool.getCacheManager(), this.file);
            btree.create((short)-1);
            String prefixStr = "KEY";
            for (int i = 1; i <= count; ++i) {
                Value value = new Value(prefixStr + Integer.toString(i));
                btree.addValue(value, i);
            }
            btree.flush();
            try (OutputStreamWriter writer = new OutputStreamWriter(System.out);){
                btree.dump(writer);
                writer.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() throws DBException, IOException, TerminatedException {
        try (BTree btree = null;){
            System.out.println("Loading btree ...");
            btree = new BTree(this.pool, 0, false, this.pool.getCacheManager(), this.file);
            btree.open((short)-1);
            System.out.println("Rebuilding ...");
            btree.rebuild();
            try (OutputStreamWriter writer = new OutputStreamWriter(System.out);){
                btree.dump(writer);
                writer.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(int count) throws DBException, IOException, TerminatedException {
        try (BTree btree = null;){
            System.out.println("Loading btree ...");
            btree = new BTree(this.pool, 0, false, this.pool.getCacheManager(), this.file);
            btree.open((short)-1);
            String prefixStr = "KEY";
            for (int i = 1; i <= count; ++i) {
                Value value = new Value(prefixStr + Integer.toString(i));
                long r = btree.findValue(value);
                if (r != -1L) continue;
                System.out.println("Key not found: " + i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int count = Integer.parseInt(args[0]);
        String command = args.length == 2 ? args[1] : null;
        BTreeTest test = new BTreeTest();
        try {
            if (command == null) {
                test.create(count);
                test.rebuild();
                test.read(count);
            } else if ("read".equals(command)) {
                test.read(count);
            } else if ("create".equals(command)) {
                test.create(count);
            } else if ("rebuild".equals(command)) {
                test.rebuild();
            }
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TerminatedException e) {
            e.printStackTrace();
        }
        finally {
            test.shutdown();
        }
    }
}

