/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Observer;
import java.util.Optional;
import org.exist.EXistException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.debuggee.Debuggee;
import org.exist.dom.persistent.SymbolTable;
import org.exist.indexing.IndexManager;
import org.exist.numbering.NodeIdFactory;
import org.exist.plugin.PluginsManager;
import org.exist.scheduler.Scheduler;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.CacheManager;
import org.exist.storage.DBBroker;
import org.exist.storage.MetaStorage;
import org.exist.storage.NotificationService;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.txn.TransactionManager;
import org.exist.util.Configuration;
import org.exist.xquery.PerformanceStats;

public interface Database {
    public String getId();

    public SecurityManager getSecurityManager();

    public IndexManager getIndexManager();

    public TransactionManager getTransactionManager();

    public CacheManager getCacheManager();

    public Scheduler getScheduler();

    public void shutdown();

    public DBBroker getBroker() throws EXistException;

    public DBBroker authenticate(String var1, Object var2) throws AuthenticationException;

    public DBBroker get(Optional<Subject> var1) throws EXistException;

    public DBBroker getActiveBroker();

    public int countActiveBrokers();

    public Debuggee getDebuggee();

    public PerformanceStats getPerformanceStats();

    public Configuration getConfiguration();

    public NodeIdFactory getNodeFactory();

    public Path getStoragePlace();

    public CollectionConfigurationManager getConfigurationManager();

    public Collection<TriggerProxy<? extends DocumentTrigger>> getDocumentTriggers();

    public Collection<TriggerProxy<? extends CollectionTrigger>> getCollectionTriggers();

    public void registerDocumentTrigger(Class<? extends DocumentTrigger> var1);

    public void registerCollectionTrigger(Class<? extends CollectionTrigger> var1);

    public ProcessMonitor getProcessMonitor();

    public boolean isReadOnly();

    public NotificationService getNotificationService();

    public PluginsManager getPluginsManager();

    public SymbolTable getSymbols();

    public MetaStorage getMetaStorage();

    public void addStatusObserver(Observer var1);

    public boolean removeStatusObserver(Observer var1);
}

