/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.Namespaces;
import org.exist.collections.CollectionConfiguration;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.ProgressIndicator;
import org.exist.util.XMLChar;
import org.exist.util.XMLString;
import org.exist.util.pool.NodePool;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class Indexer
extends Observable
implements ContentHandler,
LexicalHandler,
ErrorHandler {
    private static final int CACHE_CHILD_COUNT_MAX = 65536;
    public static final String ATTR_ID_TYPE = "ID";
    public static final String ATTR_IDREF_TYPE = "IDREF";
    public static final String ATTR_IDREFS_TYPE = "IDREFS";
    private static final Logger LOG = LogManager.getLogger(Indexer.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "indexer";
    public static final String CONFIGURATION_INDEX_ELEMENT_NAME = "index";
    public static final String SUPPRESS_WHITESPACE_ATTRIBUTE = "suppress-whitespace";
    public static final String PRESERVE_WS_MIXED_CONTENT_ATTRIBUTE = "preserve-whitespace-mixed-content";
    public static final String PROPERTY_INDEXER_CONFIG = "indexer.config";
    public static final String PROPERTY_SUPPRESS_WHITESPACE = "indexer.suppress-whitespace";
    public static final String PROPERTY_PRESERVE_WS_MIXED_CONTENT = "indexer.preserve-whitespace-mixed-content";
    private final DBBroker broker;
    private final Txn transaction;
    private StreamListener indexListener;
    private XMLString charBuf = new XMLString();
    private boolean inCDATASection = false;
    private int currentLine = 0;
    private final NodePath currentPath = new NodePath();
    private DocumentImpl document = null;
    private IndexSpec indexSpec = null;
    private boolean insideDTD = false;
    private boolean validate = false;
    private int level = 0;
    private Locator locator = null;
    private int normalize = 3;
    private final Map<String, String> nsMappings = new HashMap<String, String>();
    private Element rootNode;
    private final Deque<ElementImpl> stack = new ArrayDeque<ElementImpl>();
    private final Deque<XMLString> nodeContentStack = new ArrayDeque<XMLString>();
    private StoredNode prevNode = null;
    private String ignorePrefix = null;
    private ProgressIndicator progress;
    protected boolean preserveWSmixed = false;
    protected int docSize = 0;
    private int[] childCnt = new int[4096];
    private int elementCnt = 0;
    private int nodeFactoryInstanceCnt = 0;
    private final TextImpl text = new TextImpl();
    private final Deque<ElementImpl> usedElements = new ArrayDeque<ElementImpl>();
    private Map<String, String> entityMap = null;
    private String currentEntityName = null;
    private final XMLString currentEntityValue = new XMLString();

    public Indexer(DBBroker broker, Txn transaction) throws EXistException {
        Boolean temp;
        this.broker = broker;
        this.transaction = transaction;
        Configuration config = broker.getConfiguration();
        String suppressWS = (String)config.getProperty(PROPERTY_SUPPRESS_WHITESPACE);
        if (suppressWS != null) {
            if ("leading".equals(suppressWS)) {
                this.normalize = 1;
            } else if ("trailing".equals(suppressWS)) {
                this.normalize = 2;
            } else if ("none".equals(suppressWS)) {
                this.normalize = 0;
            }
        }
        if ((temp = (Boolean)config.getProperty(PROPERTY_PRESERVE_WS_MIXED_CONTENT)) != null) {
            this.preserveWSmixed = temp;
        }
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
        if (!validate) {
            this.indexListener = this.broker.getIndexController().getStreamListener(this.document, StreamListener.ReindexMode.STORE);
        }
    }

    public void setDocument(DocumentImpl doc, CollectionConfiguration collectionConfig) {
        this.document = doc;
        if (collectionConfig != null) {
            this.indexSpec = collectionConfig.getIndexConfiguration();
        }
        this.level = 0;
        this.currentPath.reset();
        this.stack.clear();
        this.docSize = 0;
        this.nsMappings.clear();
        this.indexListener = null;
        this.rootNode = null;
        this.setPrevious(null);
    }

    public void setDocumentObject(DocumentImpl doc) {
        this.document = doc;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public int getDocSize() {
        return this.docSize;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length <= 0) {
            return;
        }
        if (this.charBuf != null) {
            this.charBuf.append(ch, start, length);
        } else {
            this.charBuf = new XMLString(ch, start, length);
        }
        if (this.currentEntityName != null) {
            this.currentEntityValue.append(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        if (this.insideDTD) {
            return;
        }
        CommentImpl comment = new CommentImpl(ch, start, length);
        comment.setOwnerDocument(this.document);
        if (this.stack.isEmpty()) {
            comment.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            if (!this.validate) {
                this.broker.storeNode(this.transaction, comment, this.currentPath, this.indexSpec);
            }
            this.document.appendChild(comment);
        } else {
            ElementImpl last = this.stack.peek();
            this.processText(last, ProcessTextParent.COMMENT);
            last.appendChildInternal(this.prevNode, comment);
            this.setPrevious(comment);
            if (!this.validate) {
                this.broker.storeNode(this.transaction, comment, this.currentPath, this.indexSpec);
            }
        }
    }

    @Override
    public void endCDATA() {
        if (!this.stack.isEmpty()) {
            ElementImpl last = this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                CDATASectionImpl cdata = new CDATASectionImpl(this.charBuf);
                cdata.setOwnerDocument(this.document);
                last.appendChildInternal(this.prevNode, cdata);
                if (!this.validate) {
                    this.broker.storeNode(this.transaction, cdata, this.currentPath, this.indexSpec);
                    if (this.indexListener != null) {
                        this.indexListener.characters(this.transaction, cdata, this.currentPath);
                    }
                }
                this.setPrevious(cdata);
                if (!this.nodeContentStack.isEmpty()) {
                    for (XMLString next : this.nodeContentStack) {
                        next.append(this.charBuf);
                    }
                }
                this.charBuf.reset();
            }
        }
        this.inCDATASection = false;
    }

    @Override
    public void endDTD() {
        this.insideDTD = false;
    }

    @Override
    public void endDocument() {
        if (!this.validate) {
            if (this.indexListener != null) {
                this.indexListener.endIndexDocument(this.transaction);
            }
            this.progress.finish();
            this.setChanged();
            this.notifyObservers(this.progress);
        }
    }

    private void processText(ElementImpl last, ProcessTextParent ptp) {
        if (this.charBuf != null && this.charBuf.length() > 0) {
            XMLString normalized = null;
            switch (ptp) {
                case COMMENT: 
                case PI: 
                case CDATA_START: {
                    normalized = this.charBuf;
                    break;
                }
                default: {
                    if (this.charBuf.isWhitespaceOnly()) {
                        if (last.preserveSpace() || last.getChildCount() == 0) {
                            normalized = this.charBuf;
                            break;
                        }
                        if (this.preserveWSmixed) {
                            if (last.getChildCount() == 0 && (this.normalize & 1) != 0) break;
                            normalized = this.charBuf;
                            break;
                        }
                        normalized = this.charBuf.normalize(this.normalize);
                        break;
                    }
                    normalized = last.preserveSpace() ? this.charBuf : (last.getChildCount() == 0 ? this.charBuf.normalize(this.normalize) : (this.preserveWSmixed ? this.charBuf : ((this.normalize & 1) != 0 ? this.charBuf.normalize(5) : ((this.normalize & 2) != 0 ? this.charBuf.normalize(6) : this.charBuf.normalize(this.normalize)))));
                }
            }
            if (normalized != null) {
                this.text.setData(normalized);
                this.text.setOwnerDocument(this.document);
                last.appendChildInternal(this.prevNode, this.text);
                if (!this.validate) {
                    this.storeText();
                }
                this.setPrevious(this.text);
            }
            this.charBuf.reset();
        }
    }

    @Override
    public void endElement(String namespace, String name, String qname) {
        ElementImpl last = this.stack.peek();
        if (last.getNodeName().equals(qname)) {
            this.processText(last, ProcessTextParent.ELEMENT_END);
            this.stack.pop();
            XMLString elemContent = null;
            if (!this.validate && RangeIndexSpec.hasQNameOrValueIndex(last.getIndexType())) {
                elemContent = this.nodeContentStack.pop();
            }
            if (this.validate) {
                if (this.childCnt != null) {
                    this.setChildCount(last);
                }
            } else {
                String content = elemContent == null ? null : elemContent.toString();
                this.broker.endElement(last, this.currentPath, content);
                if (this.childCnt == null && last.getChildCount() > 0 || this.childCnt != null && this.childCnt[last.getPosition()] != last.getChildCount()) {
                    this.broker.updateNode(this.transaction, last, false);
                }
                if (this.indexListener != null) {
                    this.indexListener.endElement(this.transaction, last, this.currentPath);
                }
            }
            this.currentPath.removeLastComponent();
            this.setPrevious(last);
            --this.level;
        }
    }

    private void setChildCount(ElementImpl last) {
        if (last.getPosition() >= this.childCnt.length) {
            if (this.childCnt.length > 65536) {
                this.childCnt = null;
                return;
            }
            int[] n = new int[this.childCnt.length * 2];
            System.arraycopy(this.childCnt, 0, n, 0, this.childCnt.length);
            this.childCnt = n;
        }
        this.childCnt[last.getPosition()] = last.getChildCount();
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.ignorePrefix != null && prefix.equals(this.ignorePrefix)) {
            this.ignorePrefix = null;
        } else {
            this.nsMappings.remove(prefix);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String msg = "error at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        LOG.debug(msg);
        throw new SAXException(msg, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String msg = "fatal error at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        LOG.debug(msg);
        throw new SAXException(msg, e);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(target, data);
        pi.setOwnerDocument(this.document);
        if (this.stack.isEmpty()) {
            pi.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            if (!this.validate) {
                this.broker.storeNode(this.transaction, pi, this.currentPath, this.indexSpec);
            }
            this.document.appendChild(pi);
        } else {
            ElementImpl last = this.stack.peek();
            this.processText(last, ProcessTextParent.PI);
            last.appendChildInternal(this.prevNode, pi);
            this.setPrevious(pi);
            if (!this.validate) {
                this.broker.storeNode(this.transaction, pi, this.currentPath, this.indexSpec);
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startCDATA() {
        if (!this.stack.isEmpty()) {
            this.processText(this.stack.peek(), ProcessTextParent.CDATA_START);
        }
        this.inCDATASection = true;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        DocumentTypeImpl docType = new DocumentTypeImpl(name, publicId, systemId);
        this.document.setDocumentType(docType);
        this.insideDTD = true;
    }

    @Override
    public void startDocument() {
        if (!this.validate) {
            this.progress = new ProgressIndicator(this.currentLine, 100);
            this.document.setChildCount(0);
            this.elementCnt = 0;
            if (this.indexListener != null) {
                this.indexListener.startIndexDocument(this.transaction);
            }
        }
        this.docSize = 0;
        this.nodeFactoryInstanceCnt = 1;
    }

    final boolean hasNormAttribute(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equals("norm")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startElement(String namespace, String name, String qname, Attributes attributes) throws SAXException {
        ElementImpl node;
        int attrLength = attributes.getLength();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrNS = attributes.getURI(i);
            String attrQName = attributes.getQName(i);
            if (!attrQName.startsWith("xmlns") && !attrNS.equals("http://exist.sourceforge.net/NS/exist")) continue;
            --attrLength;
        }
        int p = qname.indexOf(58);
        String prefix = p != -1 ? qname.substring(0, p) : "";
        QName qn = this.broker.getBrokerPool().getSymbols().getQName((short)1, namespace, name, prefix);
        if (!this.stack.isEmpty()) {
            ElementImpl last = this.stack.peek();
            this.processText(last, ProcessTextParent.ELEMENT_START);
            try {
                if (!this.usedElements.isEmpty()) {
                    node = this.usedElements.pop();
                    node.setNodeName(qn, this.broker.getBrokerPool().getSymbols());
                } else {
                    node = new ElementImpl(qn, this.broker.getBrokerPool().getSymbols());
                }
            }
            catch (DOMException e) {
                throw new SAXException(e.getMessage(), e);
            }
            node.setPreserveSpace(last.preserveSpace());
            last.appendChildInternal(this.prevNode, node);
            this.setPrevious(null);
            node.setOwnerDocument(this.document);
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qn);
            node.setPosition(this.elementCnt++);
            if (!this.validate) {
                if (this.childCnt != null) {
                    node.setChildCount(this.childCnt[node.getPosition()]);
                }
                this.storeElement(node);
            }
        } else {
            try {
                node = new ElementImpl(qn, this.broker.getBrokerPool().getSymbols());
            }
            catch (DOMException e) {
                throw new SAXException(e.getMessage(), e);
            }
            this.rootNode = node;
            this.setPrevious(null);
            node.setOwnerDocument(this.document);
            node.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qn);
            node.setPosition(this.elementCnt++);
            if (!this.validate) {
                if (this.childCnt != null) {
                    node.setChildCount(this.childCnt[node.getPosition()]);
                }
                this.storeElement(node);
            }
            this.document.appendChild(node);
        }
        ++this.level;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrNS = attributes.getURI(i);
            String attrLocalName = attributes.getLocalName(i);
            String attrQName = attributes.getQName(i);
            if (attrQName.startsWith("xmlns") || attrNS.equals("http://exist.sourceforge.net/NS/exist")) {
                --attrLength;
                continue;
            }
            p = attrQName.indexOf(58);
            String attrPrefix = p != -1 ? attrQName.substring(0, p) : null;
            AttrImpl attr = (AttrImpl)NodePool.getInstance().borrowNode((short)2);
            QName attrQN = this.broker.getBrokerPool().getSymbols().getQName((short)2, attrNS, attrLocalName, attrPrefix);
            try {
                attr.setNodeName(attrQN, this.broker.getBrokerPool().getSymbols());
            }
            catch (DOMException e) {
                throw new SAXException(e.getMessage(), e);
            }
            attr.setValue(attributes.getValue(i));
            attr.setOwnerDocument(this.document);
            if (attributes.getType(i).equals(ATTR_ID_TYPE)) {
                attr.setType(1);
            } else if (attributes.getType(i).equals(ATTR_IDREF_TYPE)) {
                attr.setType(2);
            } else if (attributes.getType(i).equals(ATTR_IDREFS_TYPE)) {
                attr.setType(3);
            } else if (attr.getQName().equals(Namespaces.XML_ID_QNAME)) {
                attr.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attr.getValue())));
                if (!XMLChar.isValidNCName(attr.getValue())) {
                    throw new SAXException("Value of xml:id attribute is not a valid NCName: " + attr.getValue());
                }
                attr.setType(1);
            } else if (attr.getQName().equals(Namespaces.XML_SPACE_QNAME)) {
                node.setPreserveSpace("preserve".equals(attr.getValue()));
            }
            node.appendChildInternal(this.prevNode, attr);
            this.setPrevious(attr);
            if (this.validate) continue;
            this.broker.storeNode(this.transaction, attr, this.currentPath, this.indexSpec);
            if (this.indexListener == null) continue;
            this.indexListener.attribute(this.transaction, attr, this.currentPath);
        }
        if (attrLength > 0) {
            node.setAttributes((short)attrLength);
        }
        if (this.locator != null) {
            this.currentLine = this.locator.getLineNumber();
            if (!this.validate) {
                this.progress.setValue(this.currentLine);
                if (this.progress.changed()) {
                    this.setChanged();
                    this.notifyObservers(this.progress);
                }
            }
        }
        ++this.docSize;
    }

    private void storeText() {
        if (!this.nodeContentStack.isEmpty()) {
            for (XMLString next : this.nodeContentStack) {
                next.append(this.charBuf);
            }
        }
        this.broker.storeNode(this.transaction, this.text, this.currentPath, this.indexSpec);
        if (this.indexListener != null) {
            this.indexListener.characters(this.transaction, this.text, this.currentPath);
        }
    }

    private void storeElement(ElementImpl node) {
        this.broker.storeNode(this.transaction, node, this.currentPath, this.indexSpec);
        if (this.indexListener != null) {
            this.indexListener.startElement(this.transaction, node, this.currentPath);
        }
        node.setChildCount(0);
        if (RangeIndexSpec.hasQNameOrValueIndex(node.getIndexType())) {
            XMLString contentBuf = new XMLString();
            this.nodeContentStack.push(contentBuf);
        }
    }

    @Override
    public void startEntity(String name) {
        if (this.validate) {
            if (this.entityMap == null) {
                this.entityMap = new HashMap<String, String>();
            }
            this.currentEntityName = name;
        }
    }

    @Override
    public void endEntity(String name) {
        if (this.validate && this.currentEntityValue != null) {
            this.entityMap.put(this.currentEntityName, this.currentEntityValue.toString());
            this.currentEntityName = null;
            this.currentEntityValue.reset();
        }
    }

    @Override
    public void skippedEntity(String name) {
        String value;
        if (!this.validate && this.entityMap != null && (value = this.entityMap.get(name)) != null) {
            this.characters(value.toCharArray(), 0, value.length());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.nsMappings.put(prefix, uri);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        String msg = "warning at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        throw new SAXException(msg, e);
    }

    private void setPrevious(StoredNode previous) {
        if (this.prevNode != null) {
            switch (this.prevNode.getNodeType()) {
                case 2: {
                    this.prevNode.release();
                    break;
                }
                case 1: {
                    if (this.prevNode == this.rootNode) break;
                    this.prevNode.clear();
                    this.usedElements.push((ElementImpl)this.prevNode);
                    break;
                }
                case 3: {
                    this.prevNode.clear();
                }
            }
        }
        this.prevNode = previous;
    }

    private static enum ProcessTextParent {
        COMMENT,
        PI,
        CDATA_START,
        ELEMENT_START,
        ELEMENT_END;

    }
}

