/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemProperties {
    private static final Logger LOG = LogManager.getLogger(SystemProperties.class);
    private static final SystemProperties instance = new SystemProperties();
    private Properties properties = null;

    public static final SystemProperties getInstance() {
        return instance;
    }

    private SystemProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getSystemProperty(String propertyName, String defaultValue) {
        if (this.properties == null) {
            this.properties = new Properties();
            InputStream is = null;
            try {
                is = SystemProperties.class.getResourceAsStream("system.properties");
                if (is != null) {
                    this.properties.load(is);
                }
            }
            catch (IOException ioe) {
                LOG.debug("Unable to load system.properties from class loader: " + ioe.getMessage(), (Throwable)ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.properties.getProperty(propertyName, defaultValue);
    }
}

