/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.backup.BackupDescriptor;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractBackupDescriptor
implements BackupDescriptor {
    protected Date date;

    @Override
    public Date getDate() {
        if (this.date == null) {
            try {
                Properties properties = this.getProperties();
                String dateStr = properties.getProperty("date");
                if (dateStr != null) {
                    DateTimeValue dtv = new DateTimeValue(dateStr);
                    this.date = dtv.getDate();
                }
            }
            catch (IOException | XPathException exception) {
                // empty catch block
            }
            if (this.date == null) {
                this.date = new Date(0L);
            }
        }
        return this.date;
    }

    @Override
    public boolean before(long timestamp) {
        return timestamp > this.getDate().getTime();
    }

    @Override
    public void parse(ContentHandler handler) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser sax = saxFactory.newSAXParser();
        XMLReader reader = sax.getXMLReader();
        reader.setContentHandler(handler);
        reader.parse(this.getInputSource());
    }
}

