/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import org.exist.backup.BackupDialog;
import org.exist.backup.BackupWriter;
import org.exist.backup.FileSystemWriter;
import org.exist.backup.ZipWriter;
import org.exist.security.ACLPermission;
import org.exist.security.Permission;
import org.exist.util.FileUtils;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class Backup {
    private static final String EXIST_GENERATED_FILENAME_DOT_FILENAME = "_eXist_generated_backup_filename_dot_file_";
    private static final String EXIST_GENERATED_FILENAME_DOTDOT_FILENAME = "_eXist_generated_backup_filename_dotdot_file_";
    private static final int currVersion = 1;
    private Path target;
    private XmldbURI rootCollection;
    private String user;
    private String pass;
    public Properties defaultOutputProperties = new Properties();
    public Properties contentsOutputProps = new Properties();

    public Backup(String user, String pass, Path target, XmldbURI rootCollection) {
        this.defaultOutputProperties.setProperty("indent", "no");
        this.defaultOutputProperties.setProperty("encoding", "UTF-8");
        this.defaultOutputProperties.setProperty("omit-xml-declaration", "no");
        this.defaultOutputProperties.setProperty("expand-xincludes", "no");
        this.defaultOutputProperties.setProperty("process-xsl-pi", "no");
        this.contentsOutputProps.setProperty("indent", "yes");
        this.user = user;
        this.pass = pass;
        this.target = target;
        this.rootCollection = rootCollection;
    }

    public Backup(String user, String pass, Path target) {
        this(user, pass, target, XmldbURI.LOCAL_DB_URI);
    }

    public Backup(String user, String pass, Path target, XmldbURI rootCollection, Properties property) {
        this(user, pass, target, rootCollection);
        this.defaultOutputProperties.setProperty("indent", property.getProperty("indent", "no"));
    }

    public static String encode(String enco) {
        StringBuilder out = new StringBuilder();
        for (int y = 0; y < enco.length(); ++y) {
            char t = enco.charAt(y);
            if (t == '\"') {
                out.append("&22;");
                continue;
            }
            if (t == '&') {
                out.append("&26;");
                continue;
            }
            if (t == '*') {
                out.append("&2A;");
                continue;
            }
            if (t == ':') {
                out.append("&3A;");
                continue;
            }
            if (t == '<') {
                out.append("&3C;");
                continue;
            }
            if (t == '>') {
                out.append("&3E;");
                continue;
            }
            if (t == '?') {
                out.append("&3F;");
                continue;
            }
            if (t == '\\') {
                out.append("&5C;");
                continue;
            }
            if (t == '|') {
                out.append("&7C;");
                continue;
            }
            out.append(t);
        }
        return out.toString();
    }

    public static String decode(String enco) {
        StringBuilder out = new StringBuilder();
        String temp = "";
        for (int y = 0; y < enco.length(); ++y) {
            char t = enco.charAt(y);
            if (t != '&') {
                out.append(t);
                continue;
            }
            temp = enco.substring(y, y + 4);
            if ("&22;".equals(temp)) {
                out.append('\"');
            } else if ("&26;".equals(temp)) {
                out.append('&');
            } else if ("&2A;".equals(temp)) {
                out.append('*');
            } else if ("&3A;".equals(temp)) {
                out.append(':');
            } else if ("&3C;".equals(temp)) {
                out.append('<');
            } else if ("&3E;".equals(temp)) {
                out.append(">");
            } else if ("&3F;".equals(temp)) {
                out.append('?');
            } else if ("&5C;".equals(temp)) {
                out.append('\\');
            } else if ("&7C;".equals(temp)) {
                out.append('|');
            }
            y += 3;
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(boolean guiMode, JFrame parent) throws XMLDBException, IOException, SAXException {
        Collection current = DatabaseManager.getCollection((String)this.rootCollection.toString(), (String)this.user, (String)this.pass);
        if (guiMode) {
            BackupDialog dialog = new BackupDialog((Frame)parent, false);
            dialog.setSize(new Dimension(350, 150));
            dialog.setVisible(true);
            BackupThread thread = new BackupThread(current, dialog, this);
            thread.start();
            if (parent == null) {
                while (thread.isAlive()) {
                    Backup backup = this;
                    synchronized (backup) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        } else {
            this.backup(current, null);
        }
    }

    private void backup(Collection current, BackupDialog dialog) throws XMLDBException, IOException, SAXException {
        String cname = current.getName();
        if (cname.charAt(0) != '/') {
            cname = "/" + cname;
        }
        FunctionE fWriter = FileUtils.fileName(this.target).endsWith(".zip") ? currentName -> new ZipWriter(this.target, Backup.encode(URIUtils.urlDecodeUtf8(currentName))) : currentName -> {
            String child = Backup.encode(URIUtils.urlDecodeUtf8(currentName));
            if (child.charAt(0) == '/') {
                child = child.substring(1);
            }
            return new FileSystemWriter(this.target.resolve(child));
        };
        try (BackupWriter output = (BackupWriter)fWriter.apply((Object)cname);){
            this.backup(current, output, dialog);
        }
    }

    private void backup(Collection current, BackupWriter output, BackupDialog dialog) throws XMLDBException, IOException, SAXException {
        String[] collections;
        if (current == null) {
            return;
        }
        current.setProperty("encoding", this.defaultOutputProperties.getProperty("encoding"));
        current.setProperty("indent", this.defaultOutputProperties.getProperty("indent"));
        current.setProperty("expand-xincludes", this.defaultOutputProperties.getProperty("expand-xincludes"));
        current.setProperty("process-xsl-pi", this.defaultOutputProperties.getProperty("process-xsl-pi"));
        String[] resources = current.listResources();
        UserManagementService mgtService = (UserManagementService)current.getService("UserManagementService", "1.0");
        Permission[] perms = mgtService.listResourcePermissions();
        Permission currentPerms = mgtService.getPermissions(current);
        if (dialog != null) {
            dialog.setCollection(current.getName());
            dialog.setResourceCount(resources.length);
        }
        Writer contents = output.newContents();
        SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        serializer.setOutput(contents, this.contentsOutputProps);
        serializer.startDocument();
        serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
        EXistCollection cur = (EXistCollection)current;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", current.getName());
        Backup.writeUnixStylePermissionAttributes(attr, currentPerms);
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", "" + new DateTimeValue(cur.getCreationTime()));
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
        serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
        if (currentPerms instanceof ACLPermission) {
            Backup.writeACLPermission(serializer, (ACLPermission)((Object)currentPerms));
        }
        for (int i = 0; i < resources.length; ++i) {
            try {
                if ("__contents__.xml".equals(resources[i])) continue;
                Resource resource = current.getResource(resources[i]);
                if (dialog != null) {
                    dialog.setResource(resources[i]);
                    dialog.setProgress(i);
                }
                String name = resources[i];
                String filename = Backup.encode(URIUtils.urlDecodeUtf8(resources[i]));
                if (".".equals(name.trim())) {
                    filename = EXIST_GENERATED_FILENAME_DOT_FILENAME + i;
                } else if ("..".equals(name.trim())) {
                    filename = EXIST_GENERATED_FILENAME_DOTDOT_FILENAME + i;
                }
                OutputStream os = output.newEntry(filename);
                if (resource instanceof ExtendedResource) {
                    ((ExtendedResource)resource).getContentIntoAStream(os);
                } else {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                    contentSerializer.setOutput(writer, this.defaultOutputProperties);
                    ((EXistResource)resource).setLexicalHandler(contentSerializer);
                    ((XMLResource)resource).getContentAsSAX((ContentHandler)contentSerializer);
                    SerializerPool.getInstance().returnObject(contentSerializer);
                    writer.flush();
                }
                output.closeEntry();
                EXistResource ris = (EXistResource)resource;
                attr.clear();
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", resource.getResourceType());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", name);
                Backup.writeUnixStylePermissionAttributes(attr, perms[i]);
                Date date = ris.getCreationTime();
                if (date != null) {
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", "" + new DateTimeValue(date));
                }
                if ((date = ris.getLastModificationTime()) != null) {
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "modified", "modified", "CDATA", "" + new DateTimeValue(date));
                }
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", filename);
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mimetype", "mimetype", "CDATA", Backup.encode(((EXistResource)resource).getMimeType()));
                if (!"BinaryResource".equals(resource.getResourceType()) && ris.getDocType() != null) {
                    if (ris.getDocType().getName() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "namedoctype", "namedoctype", "CDATA", ris.getDocType().getName());
                    }
                    if (ris.getDocType().getPublicId() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "publicid", "publicid", "CDATA", ris.getDocType().getPublicId());
                    }
                    if (ris.getDocType().getSystemId() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "systemid", "systemid", "CDATA", ris.getDocType().getSystemId());
                    }
                }
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "resource", attr);
                if (perms[i] instanceof ACLPermission) {
                    Backup.writeACLPermission(serializer, (ACLPermission)((Object)perms[i]));
                }
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "resource");
                continue;
            }
            catch (XMLDBException e) {
                System.err.println("Failed to backup resource " + resources[i] + " from collection " + current.getName());
                throw e;
            }
        }
        for (String collection : collections = current.listChildCollections()) {
            if (current.getName().equals("/db/system") && "temp".equals(collection)) continue;
            attr.clear();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", collection);
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(collection)));
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection", attr);
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection");
        }
        serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
        serializer.endPrefixMapping("");
        serializer.endDocument();
        output.closeContents();
        SerializerPool.getInstance().returnObject(serializer);
        for (String collection : collections) {
            Collection child = current.getChildCollection(collection);
            if (child.getName().equals("/db/system/temp")) continue;
            output.newCollection(Backup.encode(URIUtils.urlDecodeUtf8(collection)));
            this.backup(child, output, dialog);
            output.closeCollection();
        }
    }

    public static void main(String[] args) {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            Backup backup = new Backup("admin", null, Paths.get("backup", new String[0]), URIUtils.encodeXmldbUriFor(args[0]));
            backup.backup(false, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void writeUnixStylePermissionAttributes(AttributesImpl attr, Permission permission) {
        if (permission == null) {
            return;
        }
        try {
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", permission.getOwner().getName());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", permission.getGroup().getName());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(permission.getMode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeACLPermission(SAXSerializer serializer, ACLPermission acl) throws SAXException {
        if (acl == null) {
            return;
        }
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "entries", "entries", "CDATA", Integer.toString(acl.getACECount()));
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", Short.toString(acl.getVersion()));
        serializer.startElement("http://exist.sourceforge.net/NS/exist", "acl", "acl", attr);
        for (int i = 0; i < acl.getACECount(); ++i) {
            attr.clear();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "index", "index", "CDATA", Integer.toString(i));
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "target", "target", "CDATA", acl.getACETarget(i).name());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "who", "who", "CDATA", acl.getACEWho(i));
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "access_type", "access_type", "CDATA", acl.getACEAccessType(i).name());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(acl.getACEMode(i)));
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "ace", "ace", attr);
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "ace", "ace");
        }
        serializer.endElement("http://exist.sourceforge.net/NS/exist", "acl", "acl");
    }

    private static class BackupThread
    extends Thread {
        private final Collection collection;
        private final BackupDialog dialog;
        private final Backup backup;
        private static final AtomicInteger backupThreadId = new AtomicInteger();

        public BackupThread(Collection collection, BackupDialog dialog, Backup backup) {
            super("exist-backupThread-" + backupThreadId.getAndIncrement());
            this.collection = collection;
            this.dialog = dialog;
            this.backup = backup;
        }

        @Override
        public void run() {
            try {
                this.backup.backup(this.collection, this.dialog);
                this.dialog.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

