/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.util.FileUtils;

public class BackupDirectory {
    public static final Logger LOG = LogManager.getLogger(BackupDirectory.class);
    public static final String PREFIX_FULL_BACKUP_FILE = "full";
    public static final String PREFIX_INC_BACKUP_FILE = "inc";
    public static final String FILE_REGEX = "(full|inc)(\\d{8}-\\d{4}).*";
    public static final String DATE_FORMAT_PICTURE = "yyyyMMdd-HHmm";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
    private Path dir;
    private Matcher matcher;

    public BackupDirectory(String dirPath) {
        this(Paths.get(dirPath, new String[0]));
    }

    public BackupDirectory(Path directory) {
        this.dir = directory;
        Pattern pattern = Pattern.compile(FILE_REGEX);
        this.matcher = pattern.matcher("");
    }

    public Path createBackup(boolean incremental, boolean zip) {
        StringBuilder buf;
        Path file;
        int counter = 0;
        do {
            buf = new StringBuilder();
            buf.append(incremental ? PREFIX_INC_BACKUP_FILE : PREFIX_FULL_BACKUP_FILE);
            buf.append(this.dateFormat.format(new Date()));
            if (counter++ > 0) {
                buf.append('_').append(counter);
            }
            if (!zip) continue;
            buf.append(".zip");
        } while (Files.exists(file = this.dir.resolve(buf.toString()), new LinkOption[0]));
        return file;
    }

    public BackupDescriptor lastBackupFile() throws IOException {
        List<Path> files = FileUtils.list(this.dir);
        Path newest = null;
        Date newestDate = null;
        for (Path file : files) {
            this.matcher.reset(FileUtils.fileName(file));
            if (!this.matcher.matches()) continue;
            String dateTime = this.matcher.group(2);
            try {
                Date date = this.dateFormat.parse(dateTime);
                if (newestDate != null && !date.after(newestDate)) continue;
                newestDate = date;
                newest = file;
            }
            catch (ParseException parseException) {}
        }
        AbstractBackupDescriptor descriptor = null;
        if (newest != null) {
            try {
                descriptor = FileUtils.fileName(newest).toLowerCase().endsWith(".zip") ? new ZipArchiveBackupDescriptor(newest) : new FileSystemBackupDescriptor(newest.resolve("db").resolve("__contents__.xml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return descriptor;
    }
}

